package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1DeploymentListBuilder extends ExtensionsV1beta1DeploymentListFluentImpl<ExtensionsV1beta1DeploymentListBuilder> implements VisitableBuilder<ExtensionsV1beta1DeploymentList,ExtensionsV1beta1DeploymentListBuilder>{

    ExtensionsV1beta1DeploymentListFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1DeploymentListBuilder(){
            this(true);
    }
    public ExtensionsV1beta1DeploymentListBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1DeploymentList(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentListBuilder(ExtensionsV1beta1DeploymentListFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1DeploymentListBuilder(ExtensionsV1beta1DeploymentListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1DeploymentList(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentListBuilder(ExtensionsV1beta1DeploymentListFluent<?> fluent,ExtensionsV1beta1DeploymentList instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1DeploymentListBuilder(ExtensionsV1beta1DeploymentListFluent<?> fluent,ExtensionsV1beta1DeploymentList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1DeploymentListBuilder(ExtensionsV1beta1DeploymentList instance){
            this(instance,true);
    }
    public ExtensionsV1beta1DeploymentListBuilder(ExtensionsV1beta1DeploymentList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1DeploymentList build(){
            ExtensionsV1beta1DeploymentList buildable = new ExtensionsV1beta1DeploymentList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1DeploymentListBuilder that = (ExtensionsV1beta1DeploymentListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
