package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ExtensionsV1beta1DeploymentListFluentImpl<A extends ExtensionsV1beta1DeploymentListFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements ExtensionsV1beta1DeploymentListFluent<A>{

    private String apiVersion;
    private List<ExtensionsV1beta1DeploymentBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public ExtensionsV1beta1DeploymentListFluentImpl(){
    }
    public ExtensionsV1beta1DeploymentListFluentImpl(ExtensionsV1beta1DeploymentList instance){
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A addToItems(int index,ExtensionsV1beta1Deployment item){
            if (this.items == null) {this.items = new ArrayList<ExtensionsV1beta1DeploymentBuilder>();}
            ExtensionsV1beta1DeploymentBuilder builder = new ExtensionsV1beta1DeploymentBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,ExtensionsV1beta1Deployment item){
            if (this.items == null) {this.items = new ArrayList<ExtensionsV1beta1DeploymentBuilder>();}
            ExtensionsV1beta1DeploymentBuilder builder = new ExtensionsV1beta1DeploymentBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(ExtensionsV1beta1Deployment... items){
            if (this.items == null) {this.items = new ArrayList<ExtensionsV1beta1DeploymentBuilder>();}
            for (ExtensionsV1beta1Deployment item : items) {ExtensionsV1beta1DeploymentBuilder builder = new ExtensionsV1beta1DeploymentBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<ExtensionsV1beta1Deployment> items){
            if (this.items == null) {this.items = new ArrayList<ExtensionsV1beta1DeploymentBuilder>();}
            for (ExtensionsV1beta1Deployment item : items) {ExtensionsV1beta1DeploymentBuilder builder = new ExtensionsV1beta1DeploymentBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(ExtensionsV1beta1Deployment... items){
            for (ExtensionsV1beta1Deployment item : items) {ExtensionsV1beta1DeploymentBuilder builder = new ExtensionsV1beta1DeploymentBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<ExtensionsV1beta1Deployment> items){
            for (ExtensionsV1beta1Deployment item : items) {ExtensionsV1beta1DeploymentBuilder builder = new ExtensionsV1beta1DeploymentBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1Deployment> getItems(){
            return build(items);
    }

    public List<ExtensionsV1beta1Deployment> buildItems(){
            return build(items);
    }

    public ExtensionsV1beta1Deployment buildItem(int index){
            return this.items.get(index).build();
    }

    public ExtensionsV1beta1Deployment buildFirstItem(){
            return this.items.get(0).build();
    }

    public ExtensionsV1beta1Deployment buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public ExtensionsV1beta1Deployment buildMatchingItem(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1DeploymentBuilder> predicate){
            for (ExtensionsV1beta1DeploymentBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<ExtensionsV1beta1Deployment> items){
            if (this.items != null) { _visitables.removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<ExtensionsV1beta1DeploymentBuilder>(); for (ExtensionsV1beta1Deployment item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(ExtensionsV1beta1Deployment... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (ExtensionsV1beta1Deployment item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public ExtensionsV1beta1DeploymentListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public ExtensionsV1beta1DeploymentListFluent.ItemsNested<A> addNewItemLike(ExtensionsV1beta1Deployment item){
            return new ItemsNestedImpl(-1, item);
    }

    public ExtensionsV1beta1DeploymentListFluent.ItemsNested<A> setNewItemLike(int index,ExtensionsV1beta1Deployment item){
            return new ItemsNestedImpl(index, item);
    }

    public ExtensionsV1beta1DeploymentListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public ExtensionsV1beta1DeploymentListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public ExtensionsV1beta1DeploymentListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public ExtensionsV1beta1DeploymentListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1DeploymentBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ListMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ListMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public ExtensionsV1beta1DeploymentListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ExtensionsV1beta1DeploymentListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public ExtensionsV1beta1DeploymentListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ExtensionsV1beta1DeploymentListFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ListMetaBuilder().build());
    }

    public ExtensionsV1beta1DeploymentListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1DeploymentListFluentImpl that = (ExtensionsV1beta1DeploymentListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends ExtensionsV1beta1DeploymentFluentImpl<ExtensionsV1beta1DeploymentListFluent.ItemsNested<N>> implements ExtensionsV1beta1DeploymentListFluent.ItemsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1DeploymentBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,ExtensionsV1beta1Deployment item){
                    this.index = index;
                    this.builder = new ExtensionsV1beta1DeploymentBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ExtensionsV1beta1DeploymentBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1DeploymentListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ListMetaFluentImpl<ExtensionsV1beta1DeploymentListFluent.MetadataNested<N>> implements ExtensionsV1beta1DeploymentListFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ListMetaBuilder builder;
    
            MetadataNestedImpl(V1ListMeta item){
                    this.builder = new V1ListMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ListMetaBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1DeploymentListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
