package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface ExtensionsV1beta1DeploymentSpecFluent<A extends ExtensionsV1beta1DeploymentSpecFluent<A>> extends Fluent<A>{


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean hasMinReadySeconds();
    public A withNewMinReadySeconds(int arg1);
    public A withNewMinReadySeconds(String arg1);
    public Boolean isPaused();
    public A withPaused(Boolean paused);
    public Boolean hasPaused();
    public A withNewPaused(boolean arg1);
    public A withNewPaused(String arg1);
    public Integer getProgressDeadlineSeconds();
    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds);
    public Boolean hasProgressDeadlineSeconds();
    public A withNewProgressDeadlineSeconds(int arg1);
    public A withNewProgressDeadlineSeconds(String arg1);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg1);
    public A withNewReplicas(String arg1);
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public Boolean hasRevisionHistoryLimit();
    public A withNewRevisionHistoryLimit(int arg1);
    public A withNewRevisionHistoryLimit(String arg1);
    
/**
 * This method has been deprecated, please use method buildRollbackTo instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1RollbackConfig getRollbackTo();
    public ExtensionsV1beta1RollbackConfig buildRollbackTo();
    public A withRollbackTo(ExtensionsV1beta1RollbackConfig rollbackTo);
    public Boolean hasRollbackTo();
    public ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<A> withNewRollbackTo();
    public ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<A> withNewRollbackToLike(ExtensionsV1beta1RollbackConfig item);
    public ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<A> editRollbackTo();
    public ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackTo();
    public ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackToLike(ExtensionsV1beta1RollbackConfig item);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector();
    public V1LabelSelector buildSelector();
    public A withSelector(V1LabelSelector selector);
    public Boolean hasSelector();
    public ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<A> withNewSelector();
    public ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item);
    public ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<A> editSelector();
    public ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<A> editOrNewSelector();
    public ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1DeploymentStrategy getStrategy();
    public ExtensionsV1beta1DeploymentStrategy buildStrategy();
    public A withStrategy(ExtensionsV1beta1DeploymentStrategy strategy);
    public Boolean hasStrategy();
    public ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<A> withNewStrategy();
    public ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(ExtensionsV1beta1DeploymentStrategy item);
    public ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<A> editStrategy();
    public ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<A> editOrNewStrategy();
    public ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<A> editOrNewStrategyLike(ExtensionsV1beta1DeploymentStrategy item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate();
    public V1PodTemplateSpec buildTemplate();
    public A withTemplate(V1PodTemplateSpec template);
    public Boolean hasTemplate();
    public ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<A> withNewTemplate();
    public ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item);
    public ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<A> editTemplate();
    public ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<A> editOrNewTemplate();
    public ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item);

    public interface RollbackToNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1RollbackConfigFluent<ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<N>>{

        
    public N and();    public N endRollbackTo();
}
    public interface SelectorNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1LabelSelectorFluent<ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<N>>{

        
    public N and();    public N endSelector();
}
    public interface StrategyNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1DeploymentStrategyFluent<ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<N>>{

        
    public N and();    public N endStrategy();
}
    public interface TemplateNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodTemplateSpecFluent<ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}


}
