package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

public class ExtensionsV1beta1DeploymentSpecFluentImpl<A extends ExtensionsV1beta1DeploymentSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements ExtensionsV1beta1DeploymentSpecFluent<A>{

    private Integer minReadySeconds;
    private Boolean paused;
    private Integer progressDeadlineSeconds;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private ExtensionsV1beta1RollbackConfigBuilder rollbackTo;
    private V1LabelSelectorBuilder selector;
    private ExtensionsV1beta1DeploymentStrategyBuilder strategy;
    private V1PodTemplateSpecBuilder template;

    public ExtensionsV1beta1DeploymentSpecFluentImpl(){
    }
    public ExtensionsV1beta1DeploymentSpecFluentImpl(ExtensionsV1beta1DeploymentSpec instance){
            this.withMinReadySeconds(instance.getMinReadySeconds());

            this.withPaused(instance.isPaused());

            this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());

            this.withReplicas(instance.getReplicas());

            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            this.withRollbackTo(instance.getRollbackTo());

            this.withSelector(instance.getSelector());

            this.withStrategy(instance.getStrategy());

            this.withTemplate(instance.getTemplate());

    }

    public Integer getMinReadySeconds(){
            return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds){
            this.minReadySeconds=minReadySeconds; return (A) this;
    }

    public Boolean hasMinReadySeconds(){
            return this.minReadySeconds != null;
    }

    public A withNewMinReadySeconds(int arg1){
            return (A)withMinReadySeconds(new Integer(arg1));
    }

    public A withNewMinReadySeconds(String arg1){
            return (A)withMinReadySeconds(new Integer(arg1));
    }

    public Boolean isPaused(){
            return this.paused;
    }

    public A withPaused(Boolean paused){
            this.paused=paused; return (A) this;
    }

    public Boolean hasPaused(){
            return this.paused != null;
    }

    public A withNewPaused(boolean arg1){
            return (A)withPaused(new Boolean(arg1));
    }

    public A withNewPaused(String arg1){
            return (A)withPaused(new Boolean(arg1));
    }

    public Integer getProgressDeadlineSeconds(){
            return this.progressDeadlineSeconds;
    }

    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds){
            this.progressDeadlineSeconds=progressDeadlineSeconds; return (A) this;
    }

    public Boolean hasProgressDeadlineSeconds(){
            return this.progressDeadlineSeconds != null;
    }

    public A withNewProgressDeadlineSeconds(int arg1){
            return (A)withProgressDeadlineSeconds(new Integer(arg1));
    }

    public A withNewProgressDeadlineSeconds(String arg1){
            return (A)withProgressDeadlineSeconds(new Integer(arg1));
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return this.replicas != null;
    }

    public A withNewReplicas(int arg1){
            return (A)withReplicas(new Integer(arg1));
    }

    public A withNewReplicas(String arg1){
            return (A)withReplicas(new Integer(arg1));
    }

    public Integer getRevisionHistoryLimit(){
            return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit){
            this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
    }

    public Boolean hasRevisionHistoryLimit(){
            return this.revisionHistoryLimit != null;
    }

    public A withNewRevisionHistoryLimit(int arg1){
            return (A)withRevisionHistoryLimit(new Integer(arg1));
    }

    public A withNewRevisionHistoryLimit(String arg1){
            return (A)withRevisionHistoryLimit(new Integer(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRollbackTo instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1RollbackConfig getRollbackTo(){
            return this.rollbackTo!=null?this.rollbackTo.build():null;
    }

    public ExtensionsV1beta1RollbackConfig buildRollbackTo(){
            return this.rollbackTo!=null?this.rollbackTo.build():null;
    }

    public A withRollbackTo(ExtensionsV1beta1RollbackConfig rollbackTo){
            _visitables.remove(this.rollbackTo);
            if (rollbackTo!=null){ this.rollbackTo= new ExtensionsV1beta1RollbackConfigBuilder(rollbackTo); _visitables.add(this.rollbackTo);} return (A) this;
    }

    public Boolean hasRollbackTo(){
            return this.rollbackTo != null;
    }

    public ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<A> withNewRollbackTo(){
            return new RollbackToNestedImpl();
    }

    public ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<A> withNewRollbackToLike(ExtensionsV1beta1RollbackConfig item){
            return new RollbackToNestedImpl(item);
    }

    public ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<A> editRollbackTo(){
            return withNewRollbackToLike(getRollbackTo());
    }

    public ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackTo(){
            return withNewRollbackToLike(getRollbackTo() != null ? getRollbackTo(): new ExtensionsV1beta1RollbackConfigBuilder().build());
    }

    public ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<A> editOrNewRollbackToLike(ExtensionsV1beta1RollbackConfig item){
            return withNewRollbackToLike(getRollbackTo() != null ? getRollbackTo(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector){
            _visitables.remove(this.selector);
            if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1DeploymentStrategy getStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public ExtensionsV1beta1DeploymentStrategy buildStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public A withStrategy(ExtensionsV1beta1DeploymentStrategy strategy){
            _visitables.remove(this.strategy);
            if (strategy!=null){ this.strategy= new ExtensionsV1beta1DeploymentStrategyBuilder(strategy); _visitables.add(this.strategy);} return (A) this;
    }

    public Boolean hasStrategy(){
            return this.strategy != null;
    }

    public ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<A> withNewStrategy(){
            return new StrategyNestedImpl();
    }

    public ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(ExtensionsV1beta1DeploymentStrategy item){
            return new StrategyNestedImpl(item);
    }

    public ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<A> editStrategy(){
            return withNewStrategyLike(getStrategy());
    }

    public ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<A> editOrNewStrategy(){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): new ExtensionsV1beta1DeploymentStrategyBuilder().build());
    }

    public ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<A> editOrNewStrategyLike(ExtensionsV1beta1DeploymentStrategy item){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public V1PodTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(V1PodTemplateSpec template){
            _visitables.remove(this.template);
            if (template!=null){ this.template= new V1PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new V1PodTemplateSpecBuilder().build());
    }

    public ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1DeploymentSpecFluentImpl that = (ExtensionsV1beta1DeploymentSpecFluentImpl) o;
            if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
            if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
            if (progressDeadlineSeconds != null ? !progressDeadlineSeconds.equals(that.progressDeadlineSeconds) :that.progressDeadlineSeconds != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
            if (rollbackTo != null ? !rollbackTo.equals(that.rollbackTo) :that.rollbackTo != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class RollbackToNestedImpl<N> extends ExtensionsV1beta1RollbackConfigFluentImpl<ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<N>> implements ExtensionsV1beta1DeploymentSpecFluent.RollbackToNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1RollbackConfigBuilder builder;
    
            RollbackToNestedImpl(ExtensionsV1beta1RollbackConfig item){
                    this.builder = new ExtensionsV1beta1RollbackConfigBuilder(this, item);
            }
            RollbackToNestedImpl(){
                    this.builder = new ExtensionsV1beta1RollbackConfigBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1DeploymentSpecFluentImpl.this.withRollbackTo(builder.build());
    }
    public N endRollbackTo(){
            return and();
    }

}
    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<N>> implements ExtensionsV1beta1DeploymentSpecFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            SelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1DeploymentSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}
    public class StrategyNestedImpl<N> extends ExtensionsV1beta1DeploymentStrategyFluentImpl<ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<N>> implements ExtensionsV1beta1DeploymentSpecFluent.StrategyNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1DeploymentStrategyBuilder builder;
    
            StrategyNestedImpl(ExtensionsV1beta1DeploymentStrategy item){
                    this.builder = new ExtensionsV1beta1DeploymentStrategyBuilder(this, item);
            }
            StrategyNestedImpl(){
                    this.builder = new ExtensionsV1beta1DeploymentStrategyBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1DeploymentSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endStrategy(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends V1PodTemplateSpecFluentImpl<ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<N>> implements ExtensionsV1beta1DeploymentSpecFluent.TemplateNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(V1PodTemplateSpec item){
                    this.builder = new V1PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new V1PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1DeploymentSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
