package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface ExtensionsV1beta1ScaleFluent<A extends ExtensionsV1beta1ScaleFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public ExtensionsV1beta1ScaleFluent.MetadataNested<A> withNewMetadata();
    public ExtensionsV1beta1ScaleFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public ExtensionsV1beta1ScaleFluent.MetadataNested<A> editMetadata();
    public ExtensionsV1beta1ScaleFluent.MetadataNested<A> editOrNewMetadata();
    public ExtensionsV1beta1ScaleFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1ScaleSpec getSpec();
    public ExtensionsV1beta1ScaleSpec buildSpec();
    public A withSpec(ExtensionsV1beta1ScaleSpec spec);
    public Boolean hasSpec();
    public ExtensionsV1beta1ScaleFluent.SpecNested<A> withNewSpec();
    public ExtensionsV1beta1ScaleFluent.SpecNested<A> withNewSpecLike(ExtensionsV1beta1ScaleSpec item);
    public ExtensionsV1beta1ScaleFluent.SpecNested<A> editSpec();
    public ExtensionsV1beta1ScaleFluent.SpecNested<A> editOrNewSpec();
    public ExtensionsV1beta1ScaleFluent.SpecNested<A> editOrNewSpecLike(ExtensionsV1beta1ScaleSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1ScaleStatus getStatus();
    public ExtensionsV1beta1ScaleStatus buildStatus();
    public A withStatus(ExtensionsV1beta1ScaleStatus status);
    public Boolean hasStatus();
    public ExtensionsV1beta1ScaleFluent.StatusNested<A> withNewStatus();
    public ExtensionsV1beta1ScaleFluent.StatusNested<A> withNewStatusLike(ExtensionsV1beta1ScaleStatus item);
    public ExtensionsV1beta1ScaleFluent.StatusNested<A> editStatus();
    public ExtensionsV1beta1ScaleFluent.StatusNested<A> editOrNewStatus();
    public ExtensionsV1beta1ScaleFluent.StatusNested<A> editOrNewStatusLike(ExtensionsV1beta1ScaleStatus item);

    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<ExtensionsV1beta1ScaleFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1ScaleSpecFluent<ExtensionsV1beta1ScaleFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1ScaleStatusFluent<ExtensionsV1beta1ScaleFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
