package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1APIServiceStatusFluentImpl<A extends V1APIServiceStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1APIServiceStatusFluent<A>{

    private List<V1APIServiceConditionBuilder> conditions;

    public V1APIServiceStatusFluentImpl(){
    }
    public V1APIServiceStatusFluentImpl(V1APIServiceStatus instance){
            this.withConditions(instance.getConditions());

    }

    public A addToConditions(int index,V1APIServiceCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1APIServiceConditionBuilder>();}
            V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1APIServiceCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1APIServiceConditionBuilder>();}
            V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(V1APIServiceCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1APIServiceConditionBuilder>();}
            for (V1APIServiceCondition item : items) {V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1APIServiceCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1APIServiceConditionBuilder>();}
            for (V1APIServiceCondition item : items) {V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1APIServiceCondition... items){
            for (V1APIServiceCondition item : items) {V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);_visitables.remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1APIServiceCondition> items){
            for (V1APIServiceCondition item : items) {V1APIServiceConditionBuilder builder = new V1APIServiceConditionBuilder(item);_visitables.remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1APIServiceCondition> getConditions(){
            return build(conditions);
    }

    public List<V1APIServiceCondition> buildConditions(){
            return build(conditions);
    }

    public V1APIServiceCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public V1APIServiceCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public V1APIServiceCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public V1APIServiceCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1APIServiceConditionBuilder> predicate){
            for (V1APIServiceConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withConditions(List<V1APIServiceCondition> conditions){
            if (this.conditions != null) { _visitables.removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<V1APIServiceConditionBuilder>(); for (V1APIServiceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1APIServiceCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (V1APIServiceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public V1APIServiceStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public V1APIServiceStatusFluent.ConditionsNested<A> addNewConditionLike(V1APIServiceCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public V1APIServiceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1APIServiceCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public V1APIServiceStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1APIServiceStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public V1APIServiceStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1APIServiceStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1APIServiceConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1APIServiceStatusFluentImpl that = (V1APIServiceStatusFluentImpl) o;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends V1APIServiceConditionFluentImpl<V1APIServiceStatusFluent.ConditionsNested<N>> implements V1APIServiceStatusFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1APIServiceConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,V1APIServiceCondition item){
                    this.index = index;
                    this.builder = new V1APIServiceConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1APIServiceConditionBuilder(this);
            }
    
    public N and(){
            return (N) V1APIServiceStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}


}
