package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class V1DeleteOptionsFluentImpl<A extends V1DeleteOptionsFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1DeleteOptionsFluent<A>{

    private String apiVersion;
    private Long gracePeriodSeconds;
    private String kind;
    private Boolean orphanDependents;
    private V1PreconditionsBuilder preconditions;
    private String propagationPolicy;

    public V1DeleteOptionsFluentImpl(){
    }
    public V1DeleteOptionsFluentImpl(V1DeleteOptions instance){
            this.withApiVersion(instance.getApiVersion());

            this.withGracePeriodSeconds(instance.getGracePeriodSeconds());

            this.withKind(instance.getKind());

            this.withOrphanDependents(instance.isOrphanDependents());

            this.withPreconditions(instance.getPreconditions());

            this.withPropagationPolicy(instance.getPropagationPolicy());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public Long getGracePeriodSeconds(){
            return this.gracePeriodSeconds;
    }

    public A withGracePeriodSeconds(Long gracePeriodSeconds){
            this.gracePeriodSeconds=gracePeriodSeconds; return (A) this;
    }

    public Boolean hasGracePeriodSeconds(){
            return this.gracePeriodSeconds != null;
    }

    public A withNewGracePeriodSeconds(String arg1){
            return (A)withGracePeriodSeconds(new Long(arg1));
    }

    public A withNewGracePeriodSeconds(long arg1){
            return (A)withGracePeriodSeconds(new Long(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public Boolean isOrphanDependents(){
            return this.orphanDependents;
    }

    public A withOrphanDependents(Boolean orphanDependents){
            this.orphanDependents=orphanDependents; return (A) this;
    }

    public Boolean hasOrphanDependents(){
            return this.orphanDependents != null;
    }

    public A withNewOrphanDependents(boolean arg1){
            return (A)withOrphanDependents(new Boolean(arg1));
    }

    public A withNewOrphanDependents(String arg1){
            return (A)withOrphanDependents(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPreconditions instead.
 * @return The buildable object.
 */
@Deprecated public V1Preconditions getPreconditions(){
            return this.preconditions!=null?this.preconditions.build():null;
    }

    public V1Preconditions buildPreconditions(){
            return this.preconditions!=null?this.preconditions.build():null;
    }

    public A withPreconditions(V1Preconditions preconditions){
            _visitables.remove(this.preconditions);
            if (preconditions!=null){ this.preconditions= new V1PreconditionsBuilder(preconditions); _visitables.add(this.preconditions);} return (A) this;
    }

    public Boolean hasPreconditions(){
            return this.preconditions != null;
    }

    public V1DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditions(){
            return new PreconditionsNestedImpl();
    }

    public V1DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditionsLike(V1Preconditions item){
            return new PreconditionsNestedImpl(item);
    }

    public V1DeleteOptionsFluent.PreconditionsNested<A> editPreconditions(){
            return withNewPreconditionsLike(getPreconditions());
    }

    public V1DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditions(){
            return withNewPreconditionsLike(getPreconditions() != null ? getPreconditions(): new V1PreconditionsBuilder().build());
    }

    public V1DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditionsLike(V1Preconditions item){
            return withNewPreconditionsLike(getPreconditions() != null ? getPreconditions(): item);
    }

    public String getPropagationPolicy(){
            return this.propagationPolicy;
    }

    public A withPropagationPolicy(String propagationPolicy){
            this.propagationPolicy=propagationPolicy; return (A) this;
    }

    public Boolean hasPropagationPolicy(){
            return this.propagationPolicy != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1DeleteOptionsFluentImpl that = (V1DeleteOptionsFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (gracePeriodSeconds != null ? !gracePeriodSeconds.equals(that.gracePeriodSeconds) :that.gracePeriodSeconds != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (orphanDependents != null ? !orphanDependents.equals(that.orphanDependents) :that.orphanDependents != null) return false;
            if (preconditions != null ? !preconditions.equals(that.preconditions) :that.preconditions != null) return false;
            if (propagationPolicy != null ? !propagationPolicy.equals(that.propagationPolicy) :that.propagationPolicy != null) return false;
            return true;
    }


    public class PreconditionsNestedImpl<N> extends V1PreconditionsFluentImpl<V1DeleteOptionsFluent.PreconditionsNested<N>> implements V1DeleteOptionsFluent.PreconditionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PreconditionsBuilder builder;
    
            PreconditionsNestedImpl(V1Preconditions item){
                    this.builder = new V1PreconditionsBuilder(this, item);
            }
            PreconditionsNestedImpl(){
                    this.builder = new V1PreconditionsBuilder(this);
            }
    
    public N and(){
            return (N) V1DeleteOptionsFluentImpl.this.withPreconditions(builder.build());
    }
    public N endPreconditions(){
            return and();
    }

}


}
