package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1DownwardAPIVolumeSourceBuilder extends V1DownwardAPIVolumeSourceFluentImpl<V1DownwardAPIVolumeSourceBuilder> implements VisitableBuilder<V1DownwardAPIVolumeSource,V1DownwardAPIVolumeSourceBuilder>{

    V1DownwardAPIVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1DownwardAPIVolumeSourceBuilder(){
            this(true);
    }
    public V1DownwardAPIVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1DownwardAPIVolumeSource(), validationEnabled);
    }
    public V1DownwardAPIVolumeSourceBuilder(V1DownwardAPIVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1DownwardAPIVolumeSourceBuilder(V1DownwardAPIVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1DownwardAPIVolumeSource(), validationEnabled);
    }
    public V1DownwardAPIVolumeSourceBuilder(V1DownwardAPIVolumeSourceFluent<?> fluent,V1DownwardAPIVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1DownwardAPIVolumeSourceBuilder(V1DownwardAPIVolumeSourceFluent<?> fluent,V1DownwardAPIVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDefaultMode(instance.getDefaultMode());

            fluent.withItems(instance.getItems());

            this.validationEnabled = validationEnabled; 
    }
    public V1DownwardAPIVolumeSourceBuilder(V1DownwardAPIVolumeSource instance){
            this(instance,true);
    }
    public V1DownwardAPIVolumeSourceBuilder(V1DownwardAPIVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDefaultMode(instance.getDefaultMode());

            this.withItems(instance.getItems());

            this.validationEnabled = validationEnabled; 
    }

    public V1DownwardAPIVolumeSource build(){
            V1DownwardAPIVolumeSource buildable = new V1DownwardAPIVolumeSource();
            buildable.setDefaultMode(fluent.getDefaultMode());
            buildable.setItems(fluent.getItems());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1DownwardAPIVolumeSourceBuilder that = (V1DownwardAPIVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
