package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1DownwardAPIVolumeSourceFluentImpl<A extends V1DownwardAPIVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1DownwardAPIVolumeSourceFluent<A>{

    private Integer defaultMode;
    private List<V1DownwardAPIVolumeFileBuilder> items;

    public V1DownwardAPIVolumeSourceFluentImpl(){
    }
    public V1DownwardAPIVolumeSourceFluentImpl(V1DownwardAPIVolumeSource instance){
            this.withDefaultMode(instance.getDefaultMode());

            this.withItems(instance.getItems());

    }

    public Integer getDefaultMode(){
            return this.defaultMode;
    }

    public A withDefaultMode(Integer defaultMode){
            this.defaultMode=defaultMode; return (A) this;
    }

    public Boolean hasDefaultMode(){
            return this.defaultMode != null;
    }

    public A withNewDefaultMode(int arg1){
            return (A)withDefaultMode(new Integer(arg1));
    }

    public A withNewDefaultMode(String arg1){
            return (A)withDefaultMode(new Integer(arg1));
    }

    public A addToItems(int index,V1DownwardAPIVolumeFile item){
            if (this.items == null) {this.items = new ArrayList<V1DownwardAPIVolumeFileBuilder>();}
            V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,V1DownwardAPIVolumeFile item){
            if (this.items == null) {this.items = new ArrayList<V1DownwardAPIVolumeFileBuilder>();}
            V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(V1DownwardAPIVolumeFile... items){
            if (this.items == null) {this.items = new ArrayList<V1DownwardAPIVolumeFileBuilder>();}
            for (V1DownwardAPIVolumeFile item : items) {V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<V1DownwardAPIVolumeFile> items){
            if (this.items == null) {this.items = new ArrayList<V1DownwardAPIVolumeFileBuilder>();}
            for (V1DownwardAPIVolumeFile item : items) {V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(V1DownwardAPIVolumeFile... items){
            for (V1DownwardAPIVolumeFile item : items) {V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<V1DownwardAPIVolumeFile> items){
            for (V1DownwardAPIVolumeFile item : items) {V1DownwardAPIVolumeFileBuilder builder = new V1DownwardAPIVolumeFileBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1DownwardAPIVolumeFile> getItems(){
            return build(items);
    }

    public List<V1DownwardAPIVolumeFile> buildItems(){
            return build(items);
    }

    public V1DownwardAPIVolumeFile buildItem(int index){
            return this.items.get(index).build();
    }

    public V1DownwardAPIVolumeFile buildFirstItem(){
            return this.items.get(0).build();
    }

    public V1DownwardAPIVolumeFile buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public V1DownwardAPIVolumeFile buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1DownwardAPIVolumeFileBuilder> predicate){
            for (V1DownwardAPIVolumeFileBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<V1DownwardAPIVolumeFile> items){
            if (this.items != null) { _visitables.removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<V1DownwardAPIVolumeFileBuilder>(); for (V1DownwardAPIVolumeFile item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(V1DownwardAPIVolumeFile... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (V1DownwardAPIVolumeFile item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItemLike(V1DownwardAPIVolumeFile item){
            return new ItemsNestedImpl(-1, item);
    }

    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index,V1DownwardAPIVolumeFile item){
            return new ItemsNestedImpl(index, item);
    }

    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1DownwardAPIVolumeSourceFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1DownwardAPIVolumeFileBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1DownwardAPIVolumeSourceFluentImpl that = (V1DownwardAPIVolumeSourceFluentImpl) o;
            if (defaultMode != null ? !defaultMode.equals(that.defaultMode) :that.defaultMode != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends V1DownwardAPIVolumeFileFluentImpl<V1DownwardAPIVolumeSourceFluent.ItemsNested<N>> implements V1DownwardAPIVolumeSourceFluent.ItemsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1DownwardAPIVolumeFileBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,V1DownwardAPIVolumeFile item){
                    this.index = index;
                    this.builder = new V1DownwardAPIVolumeFileBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1DownwardAPIVolumeFileBuilder(this);
            }
    
    public N and(){
            return (N) V1DownwardAPIVolumeSourceFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
