package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1EndpointsFluentImpl<A extends V1EndpointsFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1EndpointsFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private List<V1EndpointSubsetBuilder> subsets;

    public V1EndpointsFluentImpl(){
    }
    public V1EndpointsFluentImpl(V1Endpoints instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSubsets(instance.getSubsets());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1EndpointsFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1EndpointsFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1EndpointsFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1EndpointsFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1EndpointsFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToSubsets(int index,V1EndpointSubset item){
            if (this.subsets == null) {this.subsets = new ArrayList<V1EndpointSubsetBuilder>();}
            V1EndpointSubsetBuilder builder = new V1EndpointSubsetBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.subsets.add(index >= 0 ? index : subsets.size(), builder); return (A)this;
    }

    public A setToSubsets(int index,V1EndpointSubset item){
            if (this.subsets == null) {this.subsets = new ArrayList<V1EndpointSubsetBuilder>();}
            V1EndpointSubsetBuilder builder = new V1EndpointSubsetBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= subsets.size()) { subsets.add(builder); } else { subsets.set(index, builder);}
             return (A)this;
    }

    public A addToSubsets(V1EndpointSubset... items){
            if (this.subsets == null) {this.subsets = new ArrayList<V1EndpointSubsetBuilder>();}
            for (V1EndpointSubset item : items) {V1EndpointSubsetBuilder builder = new V1EndpointSubsetBuilder(item);_visitables.add(builder);this.subsets.add(builder);} return (A)this;
    }

    public A addAllToSubsets(Collection<V1EndpointSubset> items){
            if (this.subsets == null) {this.subsets = new ArrayList<V1EndpointSubsetBuilder>();}
            for (V1EndpointSubset item : items) {V1EndpointSubsetBuilder builder = new V1EndpointSubsetBuilder(item);_visitables.add(builder);this.subsets.add(builder);} return (A)this;
    }

    public A removeFromSubsets(V1EndpointSubset... items){
            for (V1EndpointSubset item : items) {V1EndpointSubsetBuilder builder = new V1EndpointSubsetBuilder(item);_visitables.remove(builder);if (this.subsets != null) {this.subsets.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubsets(Collection<V1EndpointSubset> items){
            for (V1EndpointSubset item : items) {V1EndpointSubsetBuilder builder = new V1EndpointSubsetBuilder(item);_visitables.remove(builder);if (this.subsets != null) {this.subsets.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubsets instead.
 * @return The buildable object.
 */
@Deprecated public List<V1EndpointSubset> getSubsets(){
            return build(subsets);
    }

    public List<V1EndpointSubset> buildSubsets(){
            return build(subsets);
    }

    public V1EndpointSubset buildSubset(int index){
            return this.subsets.get(index).build();
    }

    public V1EndpointSubset buildFirstSubset(){
            return this.subsets.get(0).build();
    }

    public V1EndpointSubset buildLastSubset(){
            return this.subsets.get(subsets.size() - 1).build();
    }

    public V1EndpointSubset buildMatchingSubset(io.kubernetes.client.fluent.Predicate<V1EndpointSubsetBuilder> predicate){
            for (V1EndpointSubsetBuilder item: subsets) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withSubsets(List<V1EndpointSubset> subsets){
            if (this.subsets != null) { _visitables.removeAll(this.subsets);}
            if (subsets != null) {this.subsets = new ArrayList<V1EndpointSubsetBuilder>(); for (V1EndpointSubset item : subsets){this.addToSubsets(item);}} else { this.subsets = null;} return (A) this;
    }

    public A withSubsets(V1EndpointSubset... subsets){
            if (this.subsets != null) {this.subsets.clear();}
            if (subsets != null) {for (V1EndpointSubset item :subsets){ this.addToSubsets(item);}} return (A) this;
    }

    public Boolean hasSubsets(){
            return subsets != null && !subsets.isEmpty();
    }

    public V1EndpointsFluent.SubsetsNested<A> addNewSubset(){
            return new SubsetsNestedImpl();
    }

    public V1EndpointsFluent.SubsetsNested<A> addNewSubsetLike(V1EndpointSubset item){
            return new SubsetsNestedImpl(-1, item);
    }

    public V1EndpointsFluent.SubsetsNested<A> setNewSubsetLike(int index,V1EndpointSubset item){
            return new SubsetsNestedImpl(index, item);
    }

    public V1EndpointsFluent.SubsetsNested<A> editSubset(int index){
            if (subsets.size() <= index) throw new RuntimeException("Can't edit subsets. Index exceeds size.");
            return setNewSubsetLike(index, buildSubset(index));
    }

    public V1EndpointsFluent.SubsetsNested<A> editFirstSubset(){
            if (subsets.size() == 0) throw new RuntimeException("Can't edit first subsets. The list is empty.");
            return setNewSubsetLike(0, buildSubset(0));
    }

    public V1EndpointsFluent.SubsetsNested<A> editLastSubset(){
            int index = subsets.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last subsets. The list is empty.");
            return setNewSubsetLike(index, buildSubset(index));
    }

    public V1EndpointsFluent.SubsetsNested<A> editMatchingSubset(io.kubernetes.client.fluent.Predicate<V1EndpointSubsetBuilder> predicate){
            int index = -1;
            for (int i=0;i<subsets.size();i++) { 
            if (predicate.apply(subsets.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching subsets. No match found.");
            return setNewSubsetLike(index, buildSubset(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1EndpointsFluentImpl that = (V1EndpointsFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (subsets != null ? !subsets.equals(that.subsets) :that.subsets != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1EndpointsFluent.MetadataNested<N>> implements V1EndpointsFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1EndpointsFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SubsetsNestedImpl<N> extends V1EndpointSubsetFluentImpl<V1EndpointsFluent.SubsetsNested<N>> implements V1EndpointsFluent.SubsetsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1EndpointSubsetBuilder builder;
        private final int index;
    
            SubsetsNestedImpl(int index,V1EndpointSubset item){
                    this.index = index;
                    this.builder = new V1EndpointSubsetBuilder(this, item);
            }
            SubsetsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1EndpointSubsetBuilder(this);
            }
    
    public N and(){
            return (N) V1EndpointsFluentImpl.this.setToSubsets(index, builder.build());
    }
    public N endSubset(){
            return and();
    }

}


}
