package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import org.joda.time.DateTime;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

public class V1EventFluentImpl<A extends V1EventFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1EventFluent<A>{

    private String action;
    private String apiVersion;
    private Integer count;
    private DateTime eventTime;
    private DateTime firstTimestamp;
    private V1ObjectReferenceBuilder involvedObject;
    private String kind;
    private DateTime lastTimestamp;
    private String message;
    private V1ObjectMetaBuilder metadata;
    private String reason;
    private V1ObjectReferenceBuilder related;
    private String reportingComponent;
    private String reportingInstance;
    private V1EventSeriesBuilder series;
    private V1EventSourceBuilder source;
    private String type;

    public V1EventFluentImpl(){
    }
    public V1EventFluentImpl(V1Event instance){
            this.withAction(instance.getAction());

            this.withApiVersion(instance.getApiVersion());

            this.withCount(instance.getCount());

            this.withEventTime(instance.getEventTime());

            this.withFirstTimestamp(instance.getFirstTimestamp());

            this.withInvolvedObject(instance.getInvolvedObject());

            this.withKind(instance.getKind());

            this.withLastTimestamp(instance.getLastTimestamp());

            this.withMessage(instance.getMessage());

            this.withMetadata(instance.getMetadata());

            this.withReason(instance.getReason());

            this.withRelated(instance.getRelated());

            this.withReportingComponent(instance.getReportingComponent());

            this.withReportingInstance(instance.getReportingInstance());

            this.withSeries(instance.getSeries());

            this.withSource(instance.getSource());

            this.withType(instance.getType());

    }

    public String getAction(){
            return this.action;
    }

    public A withAction(String action){
            this.action=action; return (A) this;
    }

    public Boolean hasAction(){
            return this.action != null;
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public Integer getCount(){
            return this.count;
    }

    public A withCount(Integer count){
            this.count=count; return (A) this;
    }

    public Boolean hasCount(){
            return this.count != null;
    }

    public A withNewCount(int arg1){
            return (A)withCount(new Integer(arg1));
    }

    public A withNewCount(String arg1){
            return (A)withCount(new Integer(arg1));
    }

    public DateTime getEventTime(){
            return this.eventTime;
    }

    public A withEventTime(DateTime eventTime){
            this.eventTime=eventTime; return (A) this;
    }

    public Boolean hasEventTime(){
            return this.eventTime != null;
    }

    public A withNewEventTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withEventTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewEventTime(long arg0){
            return (A)withEventTime(new DateTime(arg0));
    }

    public A withNewEventTime(Object arg0){
            return (A)withEventTime(new DateTime(arg0));
    }

    public DateTime getFirstTimestamp(){
            return this.firstTimestamp;
    }

    public A withFirstTimestamp(DateTime firstTimestamp){
            this.firstTimestamp=firstTimestamp; return (A) this;
    }

    public Boolean hasFirstTimestamp(){
            return this.firstTimestamp != null;
    }

    public A withNewFirstTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withFirstTimestamp(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewFirstTimestamp(long arg0){
            return (A)withFirstTimestamp(new DateTime(arg0));
    }

    public A withNewFirstTimestamp(Object arg0){
            return (A)withFirstTimestamp(new DateTime(arg0));
    }

    
/**
 * This method has been deprecated, please use method buildInvolvedObject instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getInvolvedObject(){
            return this.involvedObject!=null?this.involvedObject.build():null;
    }

    public V1ObjectReference buildInvolvedObject(){
            return this.involvedObject!=null?this.involvedObject.build():null;
    }

    public A withInvolvedObject(V1ObjectReference involvedObject){
            _visitables.remove(this.involvedObject);
            if (involvedObject!=null){ this.involvedObject= new V1ObjectReferenceBuilder(involvedObject); _visitables.add(this.involvedObject);} return (A) this;
    }

    public Boolean hasInvolvedObject(){
            return this.involvedObject != null;
    }

    public V1EventFluent.InvolvedObjectNested<A> withNewInvolvedObject(){
            return new InvolvedObjectNestedImpl();
    }

    public V1EventFluent.InvolvedObjectNested<A> withNewInvolvedObjectLike(V1ObjectReference item){
            return new InvolvedObjectNestedImpl(item);
    }

    public V1EventFluent.InvolvedObjectNested<A> editInvolvedObject(){
            return withNewInvolvedObjectLike(getInvolvedObject());
    }

    public V1EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObject(){
            return withNewInvolvedObjectLike(getInvolvedObject() != null ? getInvolvedObject(): new V1ObjectReferenceBuilder().build());
    }

    public V1EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObjectLike(V1ObjectReference item){
            return withNewInvolvedObjectLike(getInvolvedObject() != null ? getInvolvedObject(): item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public DateTime getLastTimestamp(){
            return this.lastTimestamp;
    }

    public A withLastTimestamp(DateTime lastTimestamp){
            this.lastTimestamp=lastTimestamp; return (A) this;
    }

    public Boolean hasLastTimestamp(){
            return this.lastTimestamp != null;
    }

    public A withNewLastTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withLastTimestamp(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastTimestamp(long arg0){
            return (A)withLastTimestamp(new DateTime(arg0));
    }

    public A withNewLastTimestamp(Object arg0){
            return (A)withLastTimestamp(new DateTime(arg0));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1EventFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1EventFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1EventFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1EventFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1EventFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason != null;
    }

    
/**
 * This method has been deprecated, please use method buildRelated instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getRelated(){
            return this.related!=null?this.related.build():null;
    }

    public V1ObjectReference buildRelated(){
            return this.related!=null?this.related.build():null;
    }

    public A withRelated(V1ObjectReference related){
            _visitables.remove(this.related);
            if (related!=null){ this.related= new V1ObjectReferenceBuilder(related); _visitables.add(this.related);} return (A) this;
    }

    public Boolean hasRelated(){
            return this.related != null;
    }

    public V1EventFluent.RelatedNested<A> withNewRelated(){
            return new RelatedNestedImpl();
    }

    public V1EventFluent.RelatedNested<A> withNewRelatedLike(V1ObjectReference item){
            return new RelatedNestedImpl(item);
    }

    public V1EventFluent.RelatedNested<A> editRelated(){
            return withNewRelatedLike(getRelated());
    }

    public V1EventFluent.RelatedNested<A> editOrNewRelated(){
            return withNewRelatedLike(getRelated() != null ? getRelated(): new V1ObjectReferenceBuilder().build());
    }

    public V1EventFluent.RelatedNested<A> editOrNewRelatedLike(V1ObjectReference item){
            return withNewRelatedLike(getRelated() != null ? getRelated(): item);
    }

    public String getReportingComponent(){
            return this.reportingComponent;
    }

    public A withReportingComponent(String reportingComponent){
            this.reportingComponent=reportingComponent; return (A) this;
    }

    public Boolean hasReportingComponent(){
            return this.reportingComponent != null;
    }

    public String getReportingInstance(){
            return this.reportingInstance;
    }

    public A withReportingInstance(String reportingInstance){
            this.reportingInstance=reportingInstance; return (A) this;
    }

    public Boolean hasReportingInstance(){
            return this.reportingInstance != null;
    }

    
/**
 * This method has been deprecated, please use method buildSeries instead.
 * @return The buildable object.
 */
@Deprecated public V1EventSeries getSeries(){
            return this.series!=null?this.series.build():null;
    }

    public V1EventSeries buildSeries(){
            return this.series!=null?this.series.build():null;
    }

    public A withSeries(V1EventSeries series){
            _visitables.remove(this.series);
            if (series!=null){ this.series= new V1EventSeriesBuilder(series); _visitables.add(this.series);} return (A) this;
    }

    public Boolean hasSeries(){
            return this.series != null;
    }

    public V1EventFluent.SeriesNested<A> withNewSeries(){
            return new SeriesNestedImpl();
    }

    public V1EventFluent.SeriesNested<A> withNewSeriesLike(V1EventSeries item){
            return new SeriesNestedImpl(item);
    }

    public V1EventFluent.SeriesNested<A> editSeries(){
            return withNewSeriesLike(getSeries());
    }

    public V1EventFluent.SeriesNested<A> editOrNewSeries(){
            return withNewSeriesLike(getSeries() != null ? getSeries(): new V1EventSeriesBuilder().build());
    }

    public V1EventFluent.SeriesNested<A> editOrNewSeriesLike(V1EventSeries item){
            return withNewSeriesLike(getSeries() != null ? getSeries(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSource instead.
 * @return The buildable object.
 */
@Deprecated public V1EventSource getSource(){
            return this.source!=null?this.source.build():null;
    }

    public V1EventSource buildSource(){
            return this.source!=null?this.source.build():null;
    }

    public A withSource(V1EventSource source){
            _visitables.remove(this.source);
            if (source!=null){ this.source= new V1EventSourceBuilder(source); _visitables.add(this.source);} return (A) this;
    }

    public Boolean hasSource(){
            return this.source != null;
    }

    public V1EventFluent.SourceNested<A> withNewSource(){
            return new SourceNestedImpl();
    }

    public V1EventFluent.SourceNested<A> withNewSourceLike(V1EventSource item){
            return new SourceNestedImpl(item);
    }

    public V1EventFluent.SourceNested<A> editSource(){
            return withNewSourceLike(getSource());
    }

    public V1EventFluent.SourceNested<A> editOrNewSource(){
            return withNewSourceLike(getSource() != null ? getSource(): new V1EventSourceBuilder().build());
    }

    public V1EventFluent.SourceNested<A> editOrNewSourceLike(V1EventSource item){
            return withNewSourceLike(getSource() != null ? getSource(): item);
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1EventFluentImpl that = (V1EventFluentImpl) o;
            if (action != null ? !action.equals(that.action) :that.action != null) return false;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (count != null ? !count.equals(that.count) :that.count != null) return false;
            if (eventTime != null ? !eventTime.equals(that.eventTime) :that.eventTime != null) return false;
            if (firstTimestamp != null ? !firstTimestamp.equals(that.firstTimestamp) :that.firstTimestamp != null) return false;
            if (involvedObject != null ? !involvedObject.equals(that.involvedObject) :that.involvedObject != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (lastTimestamp != null ? !lastTimestamp.equals(that.lastTimestamp) :that.lastTimestamp != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (related != null ? !related.equals(that.related) :that.related != null) return false;
            if (reportingComponent != null ? !reportingComponent.equals(that.reportingComponent) :that.reportingComponent != null) return false;
            if (reportingInstance != null ? !reportingInstance.equals(that.reportingInstance) :that.reportingInstance != null) return false;
            if (series != null ? !series.equals(that.series) :that.series != null) return false;
            if (source != null ? !source.equals(that.source) :that.source != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class InvolvedObjectNestedImpl<N> extends V1ObjectReferenceFluentImpl<V1EventFluent.InvolvedObjectNested<N>> implements V1EventFluent.InvolvedObjectNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectReferenceBuilder builder;
    
            InvolvedObjectNestedImpl(V1ObjectReference item){
                    this.builder = new V1ObjectReferenceBuilder(this, item);
            }
            InvolvedObjectNestedImpl(){
                    this.builder = new V1ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1EventFluentImpl.this.withInvolvedObject(builder.build());
    }
    public N endInvolvedObject(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1EventFluent.MetadataNested<N>> implements V1EventFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1EventFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class RelatedNestedImpl<N> extends V1ObjectReferenceFluentImpl<V1EventFluent.RelatedNested<N>> implements V1EventFluent.RelatedNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectReferenceBuilder builder;
    
            RelatedNestedImpl(V1ObjectReference item){
                    this.builder = new V1ObjectReferenceBuilder(this, item);
            }
            RelatedNestedImpl(){
                    this.builder = new V1ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1EventFluentImpl.this.withRelated(builder.build());
    }
    public N endRelated(){
            return and();
    }

}
    public class SeriesNestedImpl<N> extends V1EventSeriesFluentImpl<V1EventFluent.SeriesNested<N>> implements V1EventFluent.SeriesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1EventSeriesBuilder builder;
    
            SeriesNestedImpl(V1EventSeries item){
                    this.builder = new V1EventSeriesBuilder(this, item);
            }
            SeriesNestedImpl(){
                    this.builder = new V1EventSeriesBuilder(this);
            }
    
    public N and(){
            return (N) V1EventFluentImpl.this.withSeries(builder.build());
    }
    public N endSeries(){
            return and();
    }

}
    public class SourceNestedImpl<N> extends V1EventSourceFluentImpl<V1EventFluent.SourceNested<N>> implements V1EventFluent.SourceNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1EventSourceBuilder builder;
    
            SourceNestedImpl(V1EventSource item){
                    this.builder = new V1EventSourceBuilder(this, item);
            }
            SourceNestedImpl(){
                    this.builder = new V1EventSourceBuilder(this);
            }
    
    public N and(){
            return (N) V1EventFluentImpl.this.withSource(builder.build());
    }
    public N endSource(){
            return and();
    }

}


}
