package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1HandlerBuilder extends V1HandlerFluentImpl<V1HandlerBuilder> implements VisitableBuilder<V1Handler,V1HandlerBuilder>{

    V1HandlerFluent<?> fluent;
    Boolean validationEnabled;

    public V1HandlerBuilder(){
            this(true);
    }
    public V1HandlerBuilder(Boolean validationEnabled){
            this(new V1Handler(), validationEnabled);
    }
    public V1HandlerBuilder(V1HandlerFluent<?> fluent){
            this(fluent, true);
    }
    public V1HandlerBuilder(V1HandlerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1Handler(), validationEnabled);
    }
    public V1HandlerBuilder(V1HandlerFluent<?> fluent,V1Handler instance){
            this(fluent, instance, true);
    }
    public V1HandlerBuilder(V1HandlerFluent<?> fluent,V1Handler instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExec(instance.getExec());

            fluent.withHttpGet(instance.getHttpGet());

            fluent.withTcpSocket(instance.getTcpSocket());

            this.validationEnabled = validationEnabled; 
    }
    public V1HandlerBuilder(V1Handler instance){
            this(instance,true);
    }
    public V1HandlerBuilder(V1Handler instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExec(instance.getExec());

            this.withHttpGet(instance.getHttpGet());

            this.withTcpSocket(instance.getTcpSocket());

            this.validationEnabled = validationEnabled; 
    }

    public V1Handler build(){
            V1Handler buildable = new V1Handler();
            buildable.setExec(fluent.getExec());
            buildable.setHttpGet(fluent.getHttpGet());
            buildable.setTcpSocket(fluent.getTcpSocket());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1HandlerBuilder that = (V1HandlerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
