package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1IPBlockBuilder extends V1IPBlockFluentImpl<V1IPBlockBuilder> implements VisitableBuilder<V1IPBlock,V1IPBlockBuilder>{

    V1IPBlockFluent<?> fluent;
    Boolean validationEnabled;

    public V1IPBlockBuilder(){
            this(true);
    }
    public V1IPBlockBuilder(Boolean validationEnabled){
            this(new V1IPBlock(), validationEnabled);
    }
    public V1IPBlockBuilder(V1IPBlockFluent<?> fluent){
            this(fluent, true);
    }
    public V1IPBlockBuilder(V1IPBlockFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1IPBlock(), validationEnabled);
    }
    public V1IPBlockBuilder(V1IPBlockFluent<?> fluent,V1IPBlock instance){
            this(fluent, instance, true);
    }
    public V1IPBlockBuilder(V1IPBlockFluent<?> fluent,V1IPBlock instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCidr(instance.getCidr());

            fluent.withExcept(instance.getExcept());

            this.validationEnabled = validationEnabled; 
    }
    public V1IPBlockBuilder(V1IPBlock instance){
            this(instance,true);
    }
    public V1IPBlockBuilder(V1IPBlock instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCidr(instance.getCidr());

            this.withExcept(instance.getExcept());

            this.validationEnabled = validationEnabled; 
    }

    public V1IPBlock build(){
            V1IPBlock buildable = new V1IPBlock();
            buildable.setCidr(fluent.getCidr());
            buildable.setExcept(fluent.getExcept());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1IPBlockBuilder that = (V1IPBlockBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
