package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1NodeAddressFluentImpl<A extends V1NodeAddressFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1NodeAddressFluent<A>{

    private String address;
    private String type;

    public V1NodeAddressFluentImpl(){
    }
    public V1NodeAddressFluentImpl(V1NodeAddress instance){
            this.withAddress(instance.getAddress());

            this.withType(instance.getType());

    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NodeAddressFluentImpl that = (V1NodeAddressFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }




}
