package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ObjectFieldSelectorBuilder extends V1ObjectFieldSelectorFluentImpl<V1ObjectFieldSelectorBuilder> implements VisitableBuilder<V1ObjectFieldSelector,V1ObjectFieldSelectorBuilder>{

    V1ObjectFieldSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public V1ObjectFieldSelectorBuilder(){
            this(true);
    }
    public V1ObjectFieldSelectorBuilder(Boolean validationEnabled){
            this(new V1ObjectFieldSelector(), validationEnabled);
    }
    public V1ObjectFieldSelectorBuilder(V1ObjectFieldSelectorFluent<?> fluent){
            this(fluent, true);
    }
    public V1ObjectFieldSelectorBuilder(V1ObjectFieldSelectorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ObjectFieldSelector(), validationEnabled);
    }
    public V1ObjectFieldSelectorBuilder(V1ObjectFieldSelectorFluent<?> fluent,V1ObjectFieldSelector instance){
            this(fluent, instance, true);
    }
    public V1ObjectFieldSelectorBuilder(V1ObjectFieldSelectorFluent<?> fluent,V1ObjectFieldSelector instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withFieldPath(instance.getFieldPath());

            this.validationEnabled = validationEnabled; 
    }
    public V1ObjectFieldSelectorBuilder(V1ObjectFieldSelector instance){
            this(instance,true);
    }
    public V1ObjectFieldSelectorBuilder(V1ObjectFieldSelector instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withFieldPath(instance.getFieldPath());

            this.validationEnabled = validationEnabled; 
    }

    public V1ObjectFieldSelector build(){
            V1ObjectFieldSelector buildable = new V1ObjectFieldSelector();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setFieldPath(fluent.getFieldPath());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ObjectFieldSelectorBuilder that = (V1ObjectFieldSelectorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
