package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1OwnerReferenceFluentImpl<A extends V1OwnerReferenceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1OwnerReferenceFluent<A>{

    private String apiVersion;
    private Boolean blockOwnerDeletion;
    private Boolean controller;
    private String kind;
    private String name;
    private String uid;

    public V1OwnerReferenceFluentImpl(){
    }
    public V1OwnerReferenceFluentImpl(V1OwnerReference instance){
            this.withApiVersion(instance.getApiVersion());

            this.withBlockOwnerDeletion(instance.isBlockOwnerDeletion());

            this.withController(instance.isController());

            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.withUid(instance.getUid());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public Boolean isBlockOwnerDeletion(){
            return this.blockOwnerDeletion;
    }

    public A withBlockOwnerDeletion(Boolean blockOwnerDeletion){
            this.blockOwnerDeletion=blockOwnerDeletion; return (A) this;
    }

    public Boolean hasBlockOwnerDeletion(){
            return this.blockOwnerDeletion != null;
    }

    public A withNewBlockOwnerDeletion(boolean arg1){
            return (A)withBlockOwnerDeletion(new Boolean(arg1));
    }

    public A withNewBlockOwnerDeletion(String arg1){
            return (A)withBlockOwnerDeletion(new Boolean(arg1));
    }

    public Boolean isController(){
            return this.controller;
    }

    public A withController(Boolean controller){
            this.controller=controller; return (A) this;
    }

    public Boolean hasController(){
            return this.controller != null;
    }

    public A withNewController(boolean arg1){
            return (A)withController(new Boolean(arg1));
    }

    public A withNewController(String arg1){
            return (A)withController(new Boolean(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public String getUid(){
            return this.uid;
    }

    public A withUid(String uid){
            this.uid=uid; return (A) this;
    }

    public Boolean hasUid(){
            return this.uid != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1OwnerReferenceFluentImpl that = (V1OwnerReferenceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (blockOwnerDeletion != null ? !blockOwnerDeletion.equals(that.blockOwnerDeletion) :that.blockOwnerDeletion != null) return false;
            if (controller != null ? !controller.equals(that.controller) :that.controller != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
            return true;
    }




}
