package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PortworxVolumeSourceBuilder extends V1PortworxVolumeSourceFluentImpl<V1PortworxVolumeSourceBuilder> implements VisitableBuilder<V1PortworxVolumeSource,V1PortworxVolumeSourceBuilder>{

    V1PortworxVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1PortworxVolumeSourceBuilder(){
            this(true);
    }
    public V1PortworxVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1PortworxVolumeSource(), validationEnabled);
    }
    public V1PortworxVolumeSourceBuilder(V1PortworxVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1PortworxVolumeSourceBuilder(V1PortworxVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PortworxVolumeSource(), validationEnabled);
    }
    public V1PortworxVolumeSourceBuilder(V1PortworxVolumeSourceFluent<?> fluent,V1PortworxVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1PortworxVolumeSourceBuilder(V1PortworxVolumeSourceFluent<?> fluent,V1PortworxVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFsType(instance.getFsType());

            fluent.withReadOnly(instance.isReadOnly());

            fluent.withVolumeID(instance.getVolumeID());

            this.validationEnabled = validationEnabled; 
    }
    public V1PortworxVolumeSourceBuilder(V1PortworxVolumeSource instance){
            this(instance,true);
    }
    public V1PortworxVolumeSourceBuilder(V1PortworxVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFsType(instance.getFsType());

            this.withReadOnly(instance.isReadOnly());

            this.withVolumeID(instance.getVolumeID());

            this.validationEnabled = validationEnabled; 
    }

    public V1PortworxVolumeSource build(){
            V1PortworxVolumeSource buildable = new V1PortworxVolumeSource();
            buildable.setFsType(fluent.getFsType());
            buildable.setReadOnly(fluent.isReadOnly());
            buildable.setVolumeID(fluent.getVolumeID());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PortworxVolumeSourceBuilder that = (V1PortworxVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
