package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ReplicationControllerConditionBuilder extends V1ReplicationControllerConditionFluentImpl<V1ReplicationControllerConditionBuilder> implements VisitableBuilder<V1ReplicationControllerCondition,V1ReplicationControllerConditionBuilder>{

    V1ReplicationControllerConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1ReplicationControllerConditionBuilder(){
            this(true);
    }
    public V1ReplicationControllerConditionBuilder(Boolean validationEnabled){
            this(new V1ReplicationControllerCondition(), validationEnabled);
    }
    public V1ReplicationControllerConditionBuilder(V1ReplicationControllerConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V1ReplicationControllerConditionBuilder(V1ReplicationControllerConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ReplicationControllerCondition(), validationEnabled);
    }
    public V1ReplicationControllerConditionBuilder(V1ReplicationControllerConditionFluent<?> fluent,V1ReplicationControllerCondition instance){
            this(fluent, instance, true);
    }
    public V1ReplicationControllerConditionBuilder(V1ReplicationControllerConditionFluent<?> fluent,V1ReplicationControllerCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime());

            fluent.withMessage(instance.getMessage());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1ReplicationControllerConditionBuilder(V1ReplicationControllerCondition instance){
            this(instance,true);
    }
    public V1ReplicationControllerConditionBuilder(V1ReplicationControllerCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1ReplicationControllerCondition build(){
            V1ReplicationControllerCondition buildable = new V1ReplicationControllerCondition();
            buildable.setLastTransitionTime(fluent.getLastTransitionTime());
            buildable.setMessage(fluent.getMessage());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ReplicationControllerConditionBuilder that = (V1ReplicationControllerConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
