package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ResourceQuotaSpecBuilder extends V1ResourceQuotaSpecFluentImpl<V1ResourceQuotaSpecBuilder> implements VisitableBuilder<V1ResourceQuotaSpec,V1ResourceQuotaSpecBuilder>{

    V1ResourceQuotaSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1ResourceQuotaSpecBuilder(){
            this(true);
    }
    public V1ResourceQuotaSpecBuilder(Boolean validationEnabled){
            this(new V1ResourceQuotaSpec(), validationEnabled);
    }
    public V1ResourceQuotaSpecBuilder(V1ResourceQuotaSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1ResourceQuotaSpecBuilder(V1ResourceQuotaSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ResourceQuotaSpec(), validationEnabled);
    }
    public V1ResourceQuotaSpecBuilder(V1ResourceQuotaSpecFluent<?> fluent,V1ResourceQuotaSpec instance){
            this(fluent, instance, true);
    }
    public V1ResourceQuotaSpecBuilder(V1ResourceQuotaSpecFluent<?> fluent,V1ResourceQuotaSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHard(instance.getHard());

            fluent.withScopeSelector(instance.getScopeSelector());

            fluent.withScopes(instance.getScopes());

            this.validationEnabled = validationEnabled; 
    }
    public V1ResourceQuotaSpecBuilder(V1ResourceQuotaSpec instance){
            this(instance,true);
    }
    public V1ResourceQuotaSpecBuilder(V1ResourceQuotaSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHard(instance.getHard());

            this.withScopeSelector(instance.getScopeSelector());

            this.withScopes(instance.getScopes());

            this.validationEnabled = validationEnabled; 
    }

    public V1ResourceQuotaSpec build(){
            V1ResourceQuotaSpec buildable = new V1ResourceQuotaSpec();
            buildable.setHard(fluent.getHard());
            buildable.setScopeSelector(fluent.getScopeSelector());
            buildable.setScopes(fluent.getScopes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ResourceQuotaSpecBuilder that = (V1ResourceQuotaSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
