package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1SecretEnvSourceFluentImpl<A extends V1SecretEnvSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1SecretEnvSourceFluent<A>{

    private String name;
    private Boolean optional;

    public V1SecretEnvSourceFluentImpl(){
    }
    public V1SecretEnvSourceFluentImpl(V1SecretEnvSource instance){
            this.withName(instance.getName());

            this.withOptional(instance.isOptional());

    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public Boolean isOptional(){
            return this.optional;
    }

    public A withOptional(Boolean optional){
            this.optional=optional; return (A) this;
    }

    public Boolean hasOptional(){
            return this.optional != null;
    }

    public A withNewOptional(boolean arg1){
            return (A)withOptional(new Boolean(arg1));
    }

    public A withNewOptional(String arg1){
            return (A)withOptional(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1SecretEnvSourceFluentImpl that = (V1SecretEnvSourceFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (optional != null ? !optional.equals(that.optional) :that.optional != null) return false;
            return true;
    }




}
