package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1SecurityContextBuilder extends V1SecurityContextFluentImpl<V1SecurityContextBuilder> implements VisitableBuilder<V1SecurityContext,V1SecurityContextBuilder>{

    V1SecurityContextFluent<?> fluent;
    Boolean validationEnabled;

    public V1SecurityContextBuilder(){
            this(true);
    }
    public V1SecurityContextBuilder(Boolean validationEnabled){
            this(new V1SecurityContext(), validationEnabled);
    }
    public V1SecurityContextBuilder(V1SecurityContextFluent<?> fluent){
            this(fluent, true);
    }
    public V1SecurityContextBuilder(V1SecurityContextFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1SecurityContext(), validationEnabled);
    }
    public V1SecurityContextBuilder(V1SecurityContextFluent<?> fluent,V1SecurityContext instance){
            this(fluent, instance, true);
    }
    public V1SecurityContextBuilder(V1SecurityContextFluent<?> fluent,V1SecurityContext instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAllowPrivilegeEscalation(instance.isAllowPrivilegeEscalation());

            fluent.withCapabilities(instance.getCapabilities());

            fluent.withPrivileged(instance.isPrivileged());

            fluent.withReadOnlyRootFilesystem(instance.isReadOnlyRootFilesystem());

            fluent.withRunAsGroup(instance.getRunAsGroup());

            fluent.withRunAsNonRoot(instance.isRunAsNonRoot());

            fluent.withRunAsUser(instance.getRunAsUser());

            fluent.withSeLinuxOptions(instance.getSeLinuxOptions());

            this.validationEnabled = validationEnabled; 
    }
    public V1SecurityContextBuilder(V1SecurityContext instance){
            this(instance,true);
    }
    public V1SecurityContextBuilder(V1SecurityContext instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAllowPrivilegeEscalation(instance.isAllowPrivilegeEscalation());

            this.withCapabilities(instance.getCapabilities());

            this.withPrivileged(instance.isPrivileged());

            this.withReadOnlyRootFilesystem(instance.isReadOnlyRootFilesystem());

            this.withRunAsGroup(instance.getRunAsGroup());

            this.withRunAsNonRoot(instance.isRunAsNonRoot());

            this.withRunAsUser(instance.getRunAsUser());

            this.withSeLinuxOptions(instance.getSeLinuxOptions());

            this.validationEnabled = validationEnabled; 
    }

    public V1SecurityContext build(){
            V1SecurityContext buildable = new V1SecurityContext();
            buildable.setAllowPrivilegeEscalation(fluent.isAllowPrivilegeEscalation());
            buildable.setCapabilities(fluent.getCapabilities());
            buildable.setPrivileged(fluent.isPrivileged());
            buildable.setReadOnlyRootFilesystem(fluent.isReadOnlyRootFilesystem());
            buildable.setRunAsGroup(fluent.getRunAsGroup());
            buildable.setRunAsNonRoot(fluent.isRunAsNonRoot());
            buildable.setRunAsUser(fluent.getRunAsUser());
            buildable.setSeLinuxOptions(fluent.getSeLinuxOptions());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1SecurityContextBuilder that = (V1SecurityContextBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
