package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1InitializerBuilder extends V1alpha1InitializerFluentImpl<V1alpha1InitializerBuilder> implements VisitableBuilder<V1alpha1Initializer,V1alpha1InitializerBuilder>{

    V1alpha1InitializerFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1InitializerBuilder(){
            this(true);
    }
    public V1alpha1InitializerBuilder(Boolean validationEnabled){
            this(new V1alpha1Initializer(), validationEnabled);
    }
    public V1alpha1InitializerBuilder(V1alpha1InitializerFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1InitializerBuilder(V1alpha1InitializerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1Initializer(), validationEnabled);
    }
    public V1alpha1InitializerBuilder(V1alpha1InitializerFluent<?> fluent,V1alpha1Initializer instance){
            this(fluent, instance, true);
    }
    public V1alpha1InitializerBuilder(V1alpha1InitializerFluent<?> fluent,V1alpha1Initializer instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withRules(instance.getRules());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1InitializerBuilder(V1alpha1Initializer instance){
            this(instance,true);
    }
    public V1alpha1InitializerBuilder(V1alpha1Initializer instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withRules(instance.getRules());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1Initializer build(){
            V1alpha1Initializer buildable = new V1alpha1Initializer();
            buildable.setName(fluent.getName());
            buildable.setRules(fluent.getRules());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1InitializerBuilder that = (V1alpha1InitializerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
