package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1RoleBindingBuilder extends V1alpha1RoleBindingFluentImpl<V1alpha1RoleBindingBuilder> implements VisitableBuilder<V1alpha1RoleBinding,V1alpha1RoleBindingBuilder>{

    V1alpha1RoleBindingFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1RoleBindingBuilder(){
            this(true);
    }
    public V1alpha1RoleBindingBuilder(Boolean validationEnabled){
            this(new V1alpha1RoleBinding(), validationEnabled);
    }
    public V1alpha1RoleBindingBuilder(V1alpha1RoleBindingFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1RoleBindingBuilder(V1alpha1RoleBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1RoleBinding(), validationEnabled);
    }
    public V1alpha1RoleBindingBuilder(V1alpha1RoleBindingFluent<?> fluent,V1alpha1RoleBinding instance){
            this(fluent, instance, true);
    }
    public V1alpha1RoleBindingBuilder(V1alpha1RoleBindingFluent<?> fluent,V1alpha1RoleBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withRoleRef(instance.getRoleRef());

            fluent.withSubjects(instance.getSubjects());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1RoleBindingBuilder(V1alpha1RoleBinding instance){
            this(instance,true);
    }
    public V1alpha1RoleBindingBuilder(V1alpha1RoleBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withRoleRef(instance.getRoleRef());

            this.withSubjects(instance.getSubjects());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1RoleBinding build(){
            V1alpha1RoleBinding buildable = new V1alpha1RoleBinding();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setRoleRef(fluent.getRoleRef());
            buildable.setSubjects(fluent.getSubjects());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1RoleBindingBuilder that = (V1alpha1RoleBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
