package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import org.joda.time.DateTime;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import java.lang.Integer;
import java.lang.Object;

public interface V1beta1EventFluent<A extends V1beta1EventFluent<A>> extends Fluent<A>{


    public String getAction();
    public A withAction(String action);
    public Boolean hasAction();
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public Integer getDeprecatedCount();
    public A withDeprecatedCount(Integer deprecatedCount);
    public Boolean hasDeprecatedCount();
    public A withNewDeprecatedCount(int arg1);
    public A withNewDeprecatedCount(String arg1);
    public DateTime getDeprecatedFirstTimestamp();
    public A withDeprecatedFirstTimestamp(DateTime deprecatedFirstTimestamp);
    public Boolean hasDeprecatedFirstTimestamp();
    public A withNewDeprecatedFirstTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewDeprecatedFirstTimestamp(long arg0);
    public A withNewDeprecatedFirstTimestamp(Object arg0);
    public DateTime getDeprecatedLastTimestamp();
    public A withDeprecatedLastTimestamp(DateTime deprecatedLastTimestamp);
    public Boolean hasDeprecatedLastTimestamp();
    public A withNewDeprecatedLastTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewDeprecatedLastTimestamp(long arg0);
    public A withNewDeprecatedLastTimestamp(Object arg0);
    
/**
 * This method has been deprecated, please use method buildDeprecatedSource instead.
 * @return The buildable object.
 */
@Deprecated public V1EventSource getDeprecatedSource();
    public V1EventSource buildDeprecatedSource();
    public A withDeprecatedSource(V1EventSource deprecatedSource);
    public Boolean hasDeprecatedSource();
    public V1beta1EventFluent.DeprecatedSourceNested<A> withNewDeprecatedSource();
    public V1beta1EventFluent.DeprecatedSourceNested<A> withNewDeprecatedSourceLike(V1EventSource item);
    public V1beta1EventFluent.DeprecatedSourceNested<A> editDeprecatedSource();
    public V1beta1EventFluent.DeprecatedSourceNested<A> editOrNewDeprecatedSource();
    public V1beta1EventFluent.DeprecatedSourceNested<A> editOrNewDeprecatedSourceLike(V1EventSource item);
    public DateTime getEventTime();
    public A withEventTime(DateTime eventTime);
    public Boolean hasEventTime();
    public A withNewEventTime(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewEventTime(long arg0);
    public A withNewEventTime(Object arg0);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1beta1EventFluent.MetadataNested<A> withNewMetadata();
    public V1beta1EventFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1beta1EventFluent.MetadataNested<A> editMetadata();
    public V1beta1EventFluent.MetadataNested<A> editOrNewMetadata();
    public V1beta1EventFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    public String getNote();
    public A withNote(String note);
    public Boolean hasNote();
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    
/**
 * This method has been deprecated, please use method buildRegarding instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getRegarding();
    public V1ObjectReference buildRegarding();
    public A withRegarding(V1ObjectReference regarding);
    public Boolean hasRegarding();
    public V1beta1EventFluent.RegardingNested<A> withNewRegarding();
    public V1beta1EventFluent.RegardingNested<A> withNewRegardingLike(V1ObjectReference item);
    public V1beta1EventFluent.RegardingNested<A> editRegarding();
    public V1beta1EventFluent.RegardingNested<A> editOrNewRegarding();
    public V1beta1EventFluent.RegardingNested<A> editOrNewRegardingLike(V1ObjectReference item);
    
/**
 * This method has been deprecated, please use method buildRelated instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getRelated();
    public V1ObjectReference buildRelated();
    public A withRelated(V1ObjectReference related);
    public Boolean hasRelated();
    public V1beta1EventFluent.RelatedNested<A> withNewRelated();
    public V1beta1EventFluent.RelatedNested<A> withNewRelatedLike(V1ObjectReference item);
    public V1beta1EventFluent.RelatedNested<A> editRelated();
    public V1beta1EventFluent.RelatedNested<A> editOrNewRelated();
    public V1beta1EventFluent.RelatedNested<A> editOrNewRelatedLike(V1ObjectReference item);
    public String getReportingController();
    public A withReportingController(String reportingController);
    public Boolean hasReportingController();
    public String getReportingInstance();
    public A withReportingInstance(String reportingInstance);
    public Boolean hasReportingInstance();
    
/**
 * This method has been deprecated, please use method buildSeries instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1EventSeries getSeries();
    public V1beta1EventSeries buildSeries();
    public A withSeries(V1beta1EventSeries series);
    public Boolean hasSeries();
    public V1beta1EventFluent.SeriesNested<A> withNewSeries();
    public V1beta1EventFluent.SeriesNested<A> withNewSeriesLike(V1beta1EventSeries item);
    public V1beta1EventFluent.SeriesNested<A> editSeries();
    public V1beta1EventFluent.SeriesNested<A> editOrNewSeries();
    public V1beta1EventFluent.SeriesNested<A> editOrNewSeriesLike(V1beta1EventSeries item);
    public String getType();
    public A withType(String type);
    public Boolean hasType();

    public interface DeprecatedSourceNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1EventSourceFluent<V1beta1EventFluent.DeprecatedSourceNested<N>>{

        
    public N and();    public N endDeprecatedSource();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1beta1EventFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RegardingNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectReferenceFluent<V1beta1EventFluent.RegardingNested<N>>{

        
    public N and();    public N endRegarding();
}
    public interface RelatedNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectReferenceFluent<V1beta1EventFluent.RelatedNested<N>>{

        
    public N and();    public N endRelated();
}
    public interface SeriesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta1EventSeriesFluent<V1beta1EventFluent.SeriesNested<N>>{

        
    public N and();    public N endSeries();
}


}
