package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1IngressListBuilder extends V1beta1IngressListFluentImpl<V1beta1IngressListBuilder> implements VisitableBuilder<V1beta1IngressList,V1beta1IngressListBuilder>{

    V1beta1IngressListFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1IngressListBuilder(){
            this(true);
    }
    public V1beta1IngressListBuilder(Boolean validationEnabled){
            this(new V1beta1IngressList(), validationEnabled);
    }
    public V1beta1IngressListBuilder(V1beta1IngressListFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1IngressListBuilder(V1beta1IngressListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1IngressList(), validationEnabled);
    }
    public V1beta1IngressListBuilder(V1beta1IngressListFluent<?> fluent,V1beta1IngressList instance){
            this(fluent, instance, true);
    }
    public V1beta1IngressListBuilder(V1beta1IngressListFluent<?> fluent,V1beta1IngressList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1IngressListBuilder(V1beta1IngressList instance){
            this(instance,true);
    }
    public V1beta1IngressListBuilder(V1beta1IngressList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1IngressList build(){
            V1beta1IngressList buildable = new V1beta1IngressList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1IngressListBuilder that = (V1beta1IngressListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
