package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1IngressRuleFluentImpl<A extends V1beta1IngressRuleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1IngressRuleFluent<A>{

    private String host;
    private V1beta1HTTPIngressRuleValueBuilder http;

    public V1beta1IngressRuleFluentImpl(){
    }
    public V1beta1IngressRuleFluentImpl(V1beta1IngressRule instance){
            this.withHost(instance.getHost());

            this.withHttp(instance.getHttp());

    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    
/**
 * This method has been deprecated, please use method buildHttp instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1HTTPIngressRuleValue getHttp(){
            return this.http!=null?this.http.build():null;
    }

    public V1beta1HTTPIngressRuleValue buildHttp(){
            return this.http!=null?this.http.build():null;
    }

    public A withHttp(V1beta1HTTPIngressRuleValue http){
            _visitables.remove(this.http);
            if (http!=null){ this.http= new V1beta1HTTPIngressRuleValueBuilder(http); _visitables.add(this.http);} return (A) this;
    }

    public Boolean hasHttp(){
            return this.http != null;
    }

    public V1beta1IngressRuleFluent.HttpNested<A> withNewHttp(){
            return new HttpNestedImpl();
    }

    public V1beta1IngressRuleFluent.HttpNested<A> withNewHttpLike(V1beta1HTTPIngressRuleValue item){
            return new HttpNestedImpl(item);
    }

    public V1beta1IngressRuleFluent.HttpNested<A> editHttp(){
            return withNewHttpLike(getHttp());
    }

    public V1beta1IngressRuleFluent.HttpNested<A> editOrNewHttp(){
            return withNewHttpLike(getHttp() != null ? getHttp(): new V1beta1HTTPIngressRuleValueBuilder().build());
    }

    public V1beta1IngressRuleFluent.HttpNested<A> editOrNewHttpLike(V1beta1HTTPIngressRuleValue item){
            return withNewHttpLike(getHttp() != null ? getHttp(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1IngressRuleFluentImpl that = (V1beta1IngressRuleFluentImpl) o;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (http != null ? !http.equals(that.http) :that.http != null) return false;
            return true;
    }


    public class HttpNestedImpl<N> extends V1beta1HTTPIngressRuleValueFluentImpl<V1beta1IngressRuleFluent.HttpNested<N>> implements V1beta1IngressRuleFluent.HttpNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1HTTPIngressRuleValueBuilder builder;
    
            HttpNestedImpl(V1beta1HTTPIngressRuleValue item){
                    this.builder = new V1beta1HTTPIngressRuleValueBuilder(this, item);
            }
            HttpNestedImpl(){
                    this.builder = new V1beta1HTTPIngressRuleValueBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1IngressRuleFluentImpl.this.withHttp(builder.build());
    }
    public N endHttp(){
            return and();
    }

}


}
