package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1NetworkPolicyListBuilder extends V1beta1NetworkPolicyListFluentImpl<V1beta1NetworkPolicyListBuilder> implements VisitableBuilder<V1beta1NetworkPolicyList,V1beta1NetworkPolicyListBuilder>{

    V1beta1NetworkPolicyListFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1NetworkPolicyListBuilder(){
            this(true);
    }
    public V1beta1NetworkPolicyListBuilder(Boolean validationEnabled){
            this(new V1beta1NetworkPolicyList(), validationEnabled);
    }
    public V1beta1NetworkPolicyListBuilder(V1beta1NetworkPolicyListFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1NetworkPolicyListBuilder(V1beta1NetworkPolicyListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1NetworkPolicyList(), validationEnabled);
    }
    public V1beta1NetworkPolicyListBuilder(V1beta1NetworkPolicyListFluent<?> fluent,V1beta1NetworkPolicyList instance){
            this(fluent, instance, true);
    }
    public V1beta1NetworkPolicyListBuilder(V1beta1NetworkPolicyListFluent<?> fluent,V1beta1NetworkPolicyList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1NetworkPolicyListBuilder(V1beta1NetworkPolicyList instance){
            this(instance,true);
    }
    public V1beta1NetworkPolicyListBuilder(V1beta1NetworkPolicyList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1NetworkPolicyList build(){
            V1beta1NetworkPolicyList buildable = new V1beta1NetworkPolicyList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1NetworkPolicyListBuilder that = (V1beta1NetworkPolicyListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
