package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1SubjectAccessReviewStatusBuilder extends V1beta1SubjectAccessReviewStatusFluentImpl<V1beta1SubjectAccessReviewStatusBuilder> implements VisitableBuilder<V1beta1SubjectAccessReviewStatus,V1beta1SubjectAccessReviewStatusBuilder>{

    V1beta1SubjectAccessReviewStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1SubjectAccessReviewStatusBuilder(){
            this(true);
    }
    public V1beta1SubjectAccessReviewStatusBuilder(Boolean validationEnabled){
            this(new V1beta1SubjectAccessReviewStatus(), validationEnabled);
    }
    public V1beta1SubjectAccessReviewStatusBuilder(V1beta1SubjectAccessReviewStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1SubjectAccessReviewStatusBuilder(V1beta1SubjectAccessReviewStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1SubjectAccessReviewStatus(), validationEnabled);
    }
    public V1beta1SubjectAccessReviewStatusBuilder(V1beta1SubjectAccessReviewStatusFluent<?> fluent,V1beta1SubjectAccessReviewStatus instance){
            this(fluent, instance, true);
    }
    public V1beta1SubjectAccessReviewStatusBuilder(V1beta1SubjectAccessReviewStatusFluent<?> fluent,V1beta1SubjectAccessReviewStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAllowed(instance.isAllowed());

            fluent.withDenied(instance.isDenied());

            fluent.withEvaluationError(instance.getEvaluationError());

            fluent.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1SubjectAccessReviewStatusBuilder(V1beta1SubjectAccessReviewStatus instance){
            this(instance,true);
    }
    public V1beta1SubjectAccessReviewStatusBuilder(V1beta1SubjectAccessReviewStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAllowed(instance.isAllowed());

            this.withDenied(instance.isDenied());

            this.withEvaluationError(instance.getEvaluationError());

            this.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1SubjectAccessReviewStatus build(){
            V1beta1SubjectAccessReviewStatus buildable = new V1beta1SubjectAccessReviewStatus();
            buildable.setAllowed(fluent.isAllowed());
            buildable.setDenied(fluent.isDenied());
            buildable.setEvaluationError(fluent.getEvaluationError());
            buildable.setReason(fluent.getReason());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1SubjectAccessReviewStatusBuilder that = (V1beta1SubjectAccessReviewStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
