package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1beta1SubjectRulesReviewStatusFluentImpl<A extends V1beta1SubjectRulesReviewStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1SubjectRulesReviewStatusFluent<A>{

    private String evaluationError;
    private Boolean incomplete;
    private List<V1beta1NonResourceRuleBuilder> nonResourceRules;
    private List<V1beta1ResourceRuleBuilder> resourceRules;

    public V1beta1SubjectRulesReviewStatusFluentImpl(){
    }
    public V1beta1SubjectRulesReviewStatusFluentImpl(V1beta1SubjectRulesReviewStatus instance){
            this.withEvaluationError(instance.getEvaluationError());

            this.withIncomplete(instance.isIncomplete());

            this.withNonResourceRules(instance.getNonResourceRules());

            this.withResourceRules(instance.getResourceRules());

    }

    public String getEvaluationError(){
            return this.evaluationError;
    }

    public A withEvaluationError(String evaluationError){
            this.evaluationError=evaluationError; return (A) this;
    }

    public Boolean hasEvaluationError(){
            return this.evaluationError != null;
    }

    public Boolean isIncomplete(){
            return this.incomplete;
    }

    public A withIncomplete(Boolean incomplete){
            this.incomplete=incomplete; return (A) this;
    }

    public Boolean hasIncomplete(){
            return this.incomplete != null;
    }

    public A withNewIncomplete(boolean arg1){
            return (A)withIncomplete(new Boolean(arg1));
    }

    public A withNewIncomplete(String arg1){
            return (A)withIncomplete(new Boolean(arg1));
    }

    public A addToNonResourceRules(int index,V1beta1NonResourceRule item){
            if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<V1beta1NonResourceRuleBuilder>();}
            V1beta1NonResourceRuleBuilder builder = new V1beta1NonResourceRuleBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.nonResourceRules.add(index >= 0 ? index : nonResourceRules.size(), builder); return (A)this;
    }

    public A setToNonResourceRules(int index,V1beta1NonResourceRule item){
            if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<V1beta1NonResourceRuleBuilder>();}
            V1beta1NonResourceRuleBuilder builder = new V1beta1NonResourceRuleBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= nonResourceRules.size()) { nonResourceRules.add(builder); } else { nonResourceRules.set(index, builder);}
             return (A)this;
    }

    public A addToNonResourceRules(V1beta1NonResourceRule... items){
            if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<V1beta1NonResourceRuleBuilder>();}
            for (V1beta1NonResourceRule item : items) {V1beta1NonResourceRuleBuilder builder = new V1beta1NonResourceRuleBuilder(item);_visitables.add(builder);this.nonResourceRules.add(builder);} return (A)this;
    }

    public A addAllToNonResourceRules(Collection<V1beta1NonResourceRule> items){
            if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<V1beta1NonResourceRuleBuilder>();}
            for (V1beta1NonResourceRule item : items) {V1beta1NonResourceRuleBuilder builder = new V1beta1NonResourceRuleBuilder(item);_visitables.add(builder);this.nonResourceRules.add(builder);} return (A)this;
    }

    public A removeFromNonResourceRules(V1beta1NonResourceRule... items){
            for (V1beta1NonResourceRule item : items) {V1beta1NonResourceRuleBuilder builder = new V1beta1NonResourceRuleBuilder(item);_visitables.remove(builder);if (this.nonResourceRules != null) {this.nonResourceRules.remove(builder);}} return (A)this;
    }

    public A removeAllFromNonResourceRules(Collection<V1beta1NonResourceRule> items){
            for (V1beta1NonResourceRule item : items) {V1beta1NonResourceRuleBuilder builder = new V1beta1NonResourceRuleBuilder(item);_visitables.remove(builder);if (this.nonResourceRules != null) {this.nonResourceRules.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildNonResourceRules instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1NonResourceRule> getNonResourceRules(){
            return build(nonResourceRules);
    }

    public List<V1beta1NonResourceRule> buildNonResourceRules(){
            return build(nonResourceRules);
    }

    public V1beta1NonResourceRule buildNonResourceRule(int index){
            return this.nonResourceRules.get(index).build();
    }

    public V1beta1NonResourceRule buildFirstNonResourceRule(){
            return this.nonResourceRules.get(0).build();
    }

    public V1beta1NonResourceRule buildLastNonResourceRule(){
            return this.nonResourceRules.get(nonResourceRules.size() - 1).build();
    }

    public V1beta1NonResourceRule buildMatchingNonResourceRule(io.kubernetes.client.fluent.Predicate<V1beta1NonResourceRuleBuilder> predicate){
            for (V1beta1NonResourceRuleBuilder item: nonResourceRules) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withNonResourceRules(List<V1beta1NonResourceRule> nonResourceRules){
            if (this.nonResourceRules != null) { _visitables.removeAll(this.nonResourceRules);}
            if (nonResourceRules != null) {this.nonResourceRules = new ArrayList<V1beta1NonResourceRuleBuilder>(); for (V1beta1NonResourceRule item : nonResourceRules){this.addToNonResourceRules(item);}} else { this.nonResourceRules = null;} return (A) this;
    }

    public A withNonResourceRules(V1beta1NonResourceRule... nonResourceRules){
            if (this.nonResourceRules != null) {this.nonResourceRules.clear();}
            if (nonResourceRules != null) {for (V1beta1NonResourceRule item :nonResourceRules){ this.addToNonResourceRules(item);}} return (A) this;
    }

    public Boolean hasNonResourceRules(){
            return nonResourceRules != null && !nonResourceRules.isEmpty();
    }

    public V1beta1SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRule(){
            return new NonResourceRulesNestedImpl();
    }

    public V1beta1SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRuleLike(V1beta1NonResourceRule item){
            return new NonResourceRulesNestedImpl(-1, item);
    }

    public V1beta1SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> setNewNonResourceRuleLike(int index,V1beta1NonResourceRule item){
            return new NonResourceRulesNestedImpl(index, item);
    }

    public V1beta1SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editNonResourceRule(int index){
            if (nonResourceRules.size() <= index) throw new RuntimeException("Can't edit nonResourceRules. Index exceeds size.");
            return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
    }

    public V1beta1SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editFirstNonResourceRule(){
            if (nonResourceRules.size() == 0) throw new RuntimeException("Can't edit first nonResourceRules. The list is empty.");
            return setNewNonResourceRuleLike(0, buildNonResourceRule(0));
    }

    public V1beta1SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editLastNonResourceRule(){
            int index = nonResourceRules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last nonResourceRules. The list is empty.");
            return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
    }

    public V1beta1SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editMatchingNonResourceRule(io.kubernetes.client.fluent.Predicate<V1beta1NonResourceRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<nonResourceRules.size();i++) { 
            if (predicate.apply(nonResourceRules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching nonResourceRules. No match found.");
            return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
    }

    public A addToResourceRules(int index,V1beta1ResourceRule item){
            if (this.resourceRules == null) {this.resourceRules = new ArrayList<V1beta1ResourceRuleBuilder>();}
            V1beta1ResourceRuleBuilder builder = new V1beta1ResourceRuleBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.resourceRules.add(index >= 0 ? index : resourceRules.size(), builder); return (A)this;
    }

    public A setToResourceRules(int index,V1beta1ResourceRule item){
            if (this.resourceRules == null) {this.resourceRules = new ArrayList<V1beta1ResourceRuleBuilder>();}
            V1beta1ResourceRuleBuilder builder = new V1beta1ResourceRuleBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= resourceRules.size()) { resourceRules.add(builder); } else { resourceRules.set(index, builder);}
             return (A)this;
    }

    public A addToResourceRules(V1beta1ResourceRule... items){
            if (this.resourceRules == null) {this.resourceRules = new ArrayList<V1beta1ResourceRuleBuilder>();}
            for (V1beta1ResourceRule item : items) {V1beta1ResourceRuleBuilder builder = new V1beta1ResourceRuleBuilder(item);_visitables.add(builder);this.resourceRules.add(builder);} return (A)this;
    }

    public A addAllToResourceRules(Collection<V1beta1ResourceRule> items){
            if (this.resourceRules == null) {this.resourceRules = new ArrayList<V1beta1ResourceRuleBuilder>();}
            for (V1beta1ResourceRule item : items) {V1beta1ResourceRuleBuilder builder = new V1beta1ResourceRuleBuilder(item);_visitables.add(builder);this.resourceRules.add(builder);} return (A)this;
    }

    public A removeFromResourceRules(V1beta1ResourceRule... items){
            for (V1beta1ResourceRule item : items) {V1beta1ResourceRuleBuilder builder = new V1beta1ResourceRuleBuilder(item);_visitables.remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
    }

    public A removeAllFromResourceRules(Collection<V1beta1ResourceRule> items){
            for (V1beta1ResourceRule item : items) {V1beta1ResourceRuleBuilder builder = new V1beta1ResourceRuleBuilder(item);_visitables.remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResourceRules instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1ResourceRule> getResourceRules(){
            return build(resourceRules);
    }

    public List<V1beta1ResourceRule> buildResourceRules(){
            return build(resourceRules);
    }

    public V1beta1ResourceRule buildResourceRule(int index){
            return this.resourceRules.get(index).build();
    }

    public V1beta1ResourceRule buildFirstResourceRule(){
            return this.resourceRules.get(0).build();
    }

    public V1beta1ResourceRule buildLastResourceRule(){
            return this.resourceRules.get(resourceRules.size() - 1).build();
    }

    public V1beta1ResourceRule buildMatchingResourceRule(io.kubernetes.client.fluent.Predicate<V1beta1ResourceRuleBuilder> predicate){
            for (V1beta1ResourceRuleBuilder item: resourceRules) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withResourceRules(List<V1beta1ResourceRule> resourceRules){
            if (this.resourceRules != null) { _visitables.removeAll(this.resourceRules);}
            if (resourceRules != null) {this.resourceRules = new ArrayList<V1beta1ResourceRuleBuilder>(); for (V1beta1ResourceRule item : resourceRules){this.addToResourceRules(item);}} else { this.resourceRules = null;} return (A) this;
    }

    public A withResourceRules(V1beta1ResourceRule... resourceRules){
            if (this.resourceRules != null) {this.resourceRules.clear();}
            if (resourceRules != null) {for (V1beta1ResourceRule item :resourceRules){ this.addToResourceRules(item);}} return (A) this;
    }

    public Boolean hasResourceRules(){
            return resourceRules != null && !resourceRules.isEmpty();
    }

    public V1beta1SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRule(){
            return new ResourceRulesNestedImpl();
    }

    public V1beta1SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRuleLike(V1beta1ResourceRule item){
            return new ResourceRulesNestedImpl(-1, item);
    }

    public V1beta1SubjectRulesReviewStatusFluent.ResourceRulesNested<A> setNewResourceRuleLike(int index,V1beta1ResourceRule item){
            return new ResourceRulesNestedImpl(index, item);
    }

    public V1beta1SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editResourceRule(int index){
            if (resourceRules.size() <= index) throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
            return setNewResourceRuleLike(index, buildResourceRule(index));
    }

    public V1beta1SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editFirstResourceRule(){
            if (resourceRules.size() == 0) throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
            return setNewResourceRuleLike(0, buildResourceRule(0));
    }

    public V1beta1SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editLastResourceRule(){
            int index = resourceRules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
            return setNewResourceRuleLike(index, buildResourceRule(index));
    }

    public V1beta1SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editMatchingResourceRule(io.kubernetes.client.fluent.Predicate<V1beta1ResourceRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<resourceRules.size();i++) { 
            if (predicate.apply(resourceRules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching resourceRules. No match found.");
            return setNewResourceRuleLike(index, buildResourceRule(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1SubjectRulesReviewStatusFluentImpl that = (V1beta1SubjectRulesReviewStatusFluentImpl) o;
            if (evaluationError != null ? !evaluationError.equals(that.evaluationError) :that.evaluationError != null) return false;
            if (incomplete != null ? !incomplete.equals(that.incomplete) :that.incomplete != null) return false;
            if (nonResourceRules != null ? !nonResourceRules.equals(that.nonResourceRules) :that.nonResourceRules != null) return false;
            if (resourceRules != null ? !resourceRules.equals(that.resourceRules) :that.resourceRules != null) return false;
            return true;
    }


    public class NonResourceRulesNestedImpl<N> extends V1beta1NonResourceRuleFluentImpl<V1beta1SubjectRulesReviewStatusFluent.NonResourceRulesNested<N>> implements V1beta1SubjectRulesReviewStatusFluent.NonResourceRulesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1NonResourceRuleBuilder builder;
        private final int index;
    
            NonResourceRulesNestedImpl(int index,V1beta1NonResourceRule item){
                    this.index = index;
                    this.builder = new V1beta1NonResourceRuleBuilder(this, item);
            }
            NonResourceRulesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1NonResourceRuleBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1SubjectRulesReviewStatusFluentImpl.this.setToNonResourceRules(index, builder.build());
    }
    public N endNonResourceRule(){
            return and();
    }

}
    public class ResourceRulesNestedImpl<N> extends V1beta1ResourceRuleFluentImpl<V1beta1SubjectRulesReviewStatusFluent.ResourceRulesNested<N>> implements V1beta1SubjectRulesReviewStatusFluent.ResourceRulesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1ResourceRuleBuilder builder;
        private final int index;
    
            ResourceRulesNestedImpl(int index,V1beta1ResourceRule item){
                    this.index = index;
                    this.builder = new V1beta1ResourceRuleBuilder(this, item);
            }
            ResourceRulesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1ResourceRuleBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1SubjectRulesReviewStatusFluentImpl.this.setToResourceRules(index, builder.build());
    }
    public N endResourceRule(){
            return and();
    }

}


}
