package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1VolumeErrorBuilder extends V1beta1VolumeErrorFluentImpl<V1beta1VolumeErrorBuilder> implements VisitableBuilder<V1beta1VolumeError,V1beta1VolumeErrorBuilder>{

    V1beta1VolumeErrorFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1VolumeErrorBuilder(){
            this(true);
    }
    public V1beta1VolumeErrorBuilder(Boolean validationEnabled){
            this(new V1beta1VolumeError(), validationEnabled);
    }
    public V1beta1VolumeErrorBuilder(V1beta1VolumeErrorFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1VolumeErrorBuilder(V1beta1VolumeErrorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1VolumeError(), validationEnabled);
    }
    public V1beta1VolumeErrorBuilder(V1beta1VolumeErrorFluent<?> fluent,V1beta1VolumeError instance){
            this(fluent, instance, true);
    }
    public V1beta1VolumeErrorBuilder(V1beta1VolumeErrorFluent<?> fluent,V1beta1VolumeError instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMessage(instance.getMessage());

            fluent.withTime(instance.getTime());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1VolumeErrorBuilder(V1beta1VolumeError instance){
            this(instance,true);
    }
    public V1beta1VolumeErrorBuilder(V1beta1VolumeError instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMessage(instance.getMessage());

            this.withTime(instance.getTime());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1VolumeError build(){
            V1beta1VolumeError buildable = new V1beta1VolumeError();
            buildable.setMessage(fluent.getMessage());
            buildable.setTime(fluent.getTime());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1VolumeErrorBuilder that = (V1beta1VolumeErrorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
