package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class V1beta2DeploymentFluentImpl<A extends V1beta2DeploymentFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta2DeploymentFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1beta2DeploymentSpecBuilder spec;
    private V1beta2DeploymentStatusBuilder status;

    public V1beta2DeploymentFluentImpl(){
    }
    public V1beta2DeploymentFluentImpl(V1beta2Deployment instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1beta2DeploymentFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1beta2DeploymentFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1beta2DeploymentFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1beta2DeploymentFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1beta2DeploymentFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1beta2DeploymentSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public V1beta2DeploymentSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(V1beta2DeploymentSpec spec){
            _visitables.remove(this.spec);
            if (spec!=null){ this.spec= new V1beta2DeploymentSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public V1beta2DeploymentFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public V1beta2DeploymentFluent.SpecNested<A> withNewSpecLike(V1beta2DeploymentSpec item){
            return new SpecNestedImpl(item);
    }

    public V1beta2DeploymentFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public V1beta2DeploymentFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new V1beta2DeploymentSpecBuilder().build());
    }

    public V1beta2DeploymentFluent.SpecNested<A> editOrNewSpecLike(V1beta2DeploymentSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public V1beta2DeploymentStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public V1beta2DeploymentStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(V1beta2DeploymentStatus status){
            _visitables.remove(this.status);
            if (status!=null){ this.status= new V1beta2DeploymentStatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public V1beta2DeploymentFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public V1beta2DeploymentFluent.StatusNested<A> withNewStatusLike(V1beta2DeploymentStatus item){
            return new StatusNestedImpl(item);
    }

    public V1beta2DeploymentFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public V1beta2DeploymentFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new V1beta2DeploymentStatusBuilder().build());
    }

    public V1beta2DeploymentFluent.StatusNested<A> editOrNewStatusLike(V1beta2DeploymentStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2DeploymentFluentImpl that = (V1beta2DeploymentFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1beta2DeploymentFluent.MetadataNested<N>> implements V1beta2DeploymentFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1beta2DeploymentFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends V1beta2DeploymentSpecFluentImpl<V1beta2DeploymentFluent.SpecNested<N>> implements V1beta2DeploymentFluent.SpecNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta2DeploymentSpecBuilder builder;
    
            SpecNestedImpl(V1beta2DeploymentSpec item){
                    this.builder = new V1beta2DeploymentSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new V1beta2DeploymentSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1beta2DeploymentFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends V1beta2DeploymentStatusFluentImpl<V1beta2DeploymentFluent.StatusNested<N>> implements V1beta2DeploymentFluent.StatusNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta2DeploymentStatusBuilder builder;
    
            StatusNestedImpl(V1beta2DeploymentStatus item){
                    this.builder = new V1beta2DeploymentStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new V1beta2DeploymentStatusBuilder(this);
            }
    
    public N and(){
            return (N) V1beta2DeploymentFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
