package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2alpha1CronJobListBuilder extends V2alpha1CronJobListFluentImpl<V2alpha1CronJobListBuilder> implements VisitableBuilder<V2alpha1CronJobList,V2alpha1CronJobListBuilder>{

    V2alpha1CronJobListFluent<?> fluent;
    Boolean validationEnabled;

    public V2alpha1CronJobListBuilder(){
            this(true);
    }
    public V2alpha1CronJobListBuilder(Boolean validationEnabled){
            this(new V2alpha1CronJobList(), validationEnabled);
    }
    public V2alpha1CronJobListBuilder(V2alpha1CronJobListFluent<?> fluent){
            this(fluent, true);
    }
    public V2alpha1CronJobListBuilder(V2alpha1CronJobListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2alpha1CronJobList(), validationEnabled);
    }
    public V2alpha1CronJobListBuilder(V2alpha1CronJobListFluent<?> fluent,V2alpha1CronJobList instance){
            this(fluent, instance, true);
    }
    public V2alpha1CronJobListBuilder(V2alpha1CronJobListFluent<?> fluent,V2alpha1CronJobList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V2alpha1CronJobListBuilder(V2alpha1CronJobList instance){
            this(instance,true);
    }
    public V2alpha1CronJobListBuilder(V2alpha1CronJobList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V2alpha1CronJobList build(){
            V2alpha1CronJobList buildable = new V2alpha1CronJobList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2alpha1CronJobListBuilder that = (V2alpha1CronJobListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
