package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1ExternalMetricStatusFluentImpl<A extends V2beta1ExternalMetricStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta1ExternalMetricStatusFluent<A>{

    private String currentAverageValue;
    private String currentValue;
    private String metricName;
    private V1LabelSelectorBuilder metricSelector;

    public V2beta1ExternalMetricStatusFluentImpl(){
    }
    public V2beta1ExternalMetricStatusFluentImpl(V2beta1ExternalMetricStatus instance){
            this.withCurrentAverageValue(instance.getCurrentAverageValue());

            this.withCurrentValue(instance.getCurrentValue());

            this.withMetricName(instance.getMetricName());

            this.withMetricSelector(instance.getMetricSelector());

    }

    public String getCurrentAverageValue(){
            return this.currentAverageValue;
    }

    public A withCurrentAverageValue(String currentAverageValue){
            this.currentAverageValue=currentAverageValue; return (A) this;
    }

    public Boolean hasCurrentAverageValue(){
            return this.currentAverageValue != null;
    }

    public String getCurrentValue(){
            return this.currentValue;
    }

    public A withCurrentValue(String currentValue){
            this.currentValue=currentValue; return (A) this;
    }

    public Boolean hasCurrentValue(){
            return this.currentValue != null;
    }

    public String getMetricName(){
            return this.metricName;
    }

    public A withMetricName(String metricName){
            this.metricName=metricName; return (A) this;
    }

    public Boolean hasMetricName(){
            return this.metricName != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetricSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getMetricSelector(){
            return this.metricSelector!=null?this.metricSelector.build():null;
    }

    public V1LabelSelector buildMetricSelector(){
            return this.metricSelector!=null?this.metricSelector.build():null;
    }

    public A withMetricSelector(V1LabelSelector metricSelector){
            _visitables.remove(this.metricSelector);
            if (metricSelector!=null){ this.metricSelector= new V1LabelSelectorBuilder(metricSelector); _visitables.add(this.metricSelector);} return (A) this;
    }

    public Boolean hasMetricSelector(){
            return this.metricSelector != null;
    }

    public V2beta1ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelector(){
            return new MetricSelectorNestedImpl();
    }

    public V2beta1ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelectorLike(V1LabelSelector item){
            return new MetricSelectorNestedImpl(item);
    }

    public V2beta1ExternalMetricStatusFluent.MetricSelectorNested<A> editMetricSelector(){
            return withNewMetricSelectorLike(getMetricSelector());
    }

    public V2beta1ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelector(){
            return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): new V1LabelSelectorBuilder().build());
    }

    public V2beta1ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(V1LabelSelector item){
            return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1ExternalMetricStatusFluentImpl that = (V2beta1ExternalMetricStatusFluentImpl) o;
            if (currentAverageValue != null ? !currentAverageValue.equals(that.currentAverageValue) :that.currentAverageValue != null) return false;
            if (currentValue != null ? !currentValue.equals(that.currentValue) :that.currentValue != null) return false;
            if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
            if (metricSelector != null ? !metricSelector.equals(that.metricSelector) :that.metricSelector != null) return false;
            return true;
    }


    public class MetricSelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V2beta1ExternalMetricStatusFluent.MetricSelectorNested<N>> implements V2beta1ExternalMetricStatusFluent.MetricSelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            MetricSelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            MetricSelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V2beta1ExternalMetricStatusFluentImpl.this.withMetricSelector(builder.build());
    }
    public N endMetricSelector(){
            return and();
    }

}


}
