package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1ResourceMetricSourceBuilder extends V2beta1ResourceMetricSourceFluentImpl<V2beta1ResourceMetricSourceBuilder> implements VisitableBuilder<V2beta1ResourceMetricSource,V2beta1ResourceMetricSourceBuilder>{

    V2beta1ResourceMetricSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta1ResourceMetricSourceBuilder(){
            this(true);
    }
    public V2beta1ResourceMetricSourceBuilder(Boolean validationEnabled){
            this(new V2beta1ResourceMetricSource(), validationEnabled);
    }
    public V2beta1ResourceMetricSourceBuilder(V2beta1ResourceMetricSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V2beta1ResourceMetricSourceBuilder(V2beta1ResourceMetricSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2beta1ResourceMetricSource(), validationEnabled);
    }
    public V2beta1ResourceMetricSourceBuilder(V2beta1ResourceMetricSourceFluent<?> fluent,V2beta1ResourceMetricSource instance){
            this(fluent, instance, true);
    }
    public V2beta1ResourceMetricSourceBuilder(V2beta1ResourceMetricSourceFluent<?> fluent,V2beta1ResourceMetricSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withTargetAverageUtilization(instance.getTargetAverageUtilization());

            fluent.withTargetAverageValue(instance.getTargetAverageValue());

            this.validationEnabled = validationEnabled; 
    }
    public V2beta1ResourceMetricSourceBuilder(V2beta1ResourceMetricSource instance){
            this(instance,true);
    }
    public V2beta1ResourceMetricSourceBuilder(V2beta1ResourceMetricSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withTargetAverageUtilization(instance.getTargetAverageUtilization());

            this.withTargetAverageValue(instance.getTargetAverageValue());

            this.validationEnabled = validationEnabled; 
    }

    public V2beta1ResourceMetricSource build(){
            V2beta1ResourceMetricSource buildable = new V2beta1ResourceMetricSource();
            buildable.setName(fluent.getName());
            buildable.setTargetAverageUtilization(fluent.getTargetAverageUtilization());
            buildable.setTargetAverageValue(fluent.getTargetAverageValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1ResourceMetricSourceBuilder that = (V2beta1ResourceMetricSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
