package io.kubernetes.client.models;

import java.lang.Integer;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.custom.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V2beta1ResourceMetricSourceFluentImpl<A extends V2beta1ResourceMetricSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta1ResourceMetricSourceFluent<A>{

    private String name;
    private Integer targetAverageUtilization;
    private Quantity targetAverageValue;

    public V2beta1ResourceMetricSourceFluentImpl(){
    }
    public V2beta1ResourceMetricSourceFluentImpl(V2beta1ResourceMetricSource instance){
            this.withName(instance.getName());

            this.withTargetAverageUtilization(instance.getTargetAverageUtilization());

            this.withTargetAverageValue(instance.getTargetAverageValue());

    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public Integer getTargetAverageUtilization(){
            return this.targetAverageUtilization;
    }

    public A withTargetAverageUtilization(Integer targetAverageUtilization){
            this.targetAverageUtilization=targetAverageUtilization; return (A) this;
    }

    public Boolean hasTargetAverageUtilization(){
            return this.targetAverageUtilization != null;
    }

    public A withNewTargetAverageUtilization(int arg1){
            return (A)withTargetAverageUtilization(new Integer(arg1));
    }

    public A withNewTargetAverageUtilization(String arg1){
            return (A)withTargetAverageUtilization(new Integer(arg1));
    }

    public Quantity getTargetAverageValue(){
            return this.targetAverageValue;
    }

    public A withTargetAverageValue(Quantity targetAverageValue){
            this.targetAverageValue=targetAverageValue; return (A) this;
    }

    public Boolean hasTargetAverageValue(){
            return this.targetAverageValue != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1ResourceMetricSourceFluentImpl that = (V2beta1ResourceMetricSourceFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (targetAverageUtilization != null ? !targetAverageUtilization.equals(that.targetAverageUtilization) :that.targetAverageUtilization != null) return false;
            if (targetAverageValue != null ? !targetAverageValue.equals(that.targetAverageValue) :that.targetAverageValue != null) return false;
            return true;
    }




}
