/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Parser;
import io.nats.client.Subscription;
import io.nats.client.SubscriptionImpl;
import java.util.Arrays;

public class Message {
    private SubscriptionImpl sub;
    private byte[] subjectBytes;
    private String subjectString;
    private byte[] replyToBytes;
    private String replyToString;
    private byte[] data;

    public Message() {
    }

    public Message(String subject, String reply, byte[] data) {
        this(data, subject, reply, null);
    }

    Message(Parser.MsgArg ma, SubscriptionImpl sub, byte[] buf, int offset, int length) {
        this.setSubject(ma.subject.array(), ma.subject.limit());
        if (ma.reply.limit() > 0) {
            this.setReplyTo(ma.reply.array(), ma.reply.limit());
        }
        this.sub = sub;
        if (length > 0) {
            if (length > buf.length) {
                String msg = String.format("nats: source buffer size (%d) smaller than requested copy length(%d)", length, buf.length);
                throw new IllegalArgumentException(msg);
            }
            if (length > ma.size) {
                String msg = String.format("nats: requested copy length(%d) larger than ma.size(%d)", length, ma.size);
                throw new IllegalArgumentException(msg);
            }
            this.data = new byte[length];
            System.arraycopy(buf, offset, this.data, 0, length);
        }
    }

    Message(byte[] data, String subject, String reply, SubscriptionImpl sub) {
        if (subject == null) {
            throw new NullPointerException("Subject cannot be null");
        }
        this.setSubject(subject);
        this.setData(data);
        this.setReplyTo(reply);
        this.sub = sub;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        if (data != null) {
            this.setData(data, 0, data.length);
        } else {
            this.setData(null, 0, 0);
        }
    }

    public String getSubject() {
        if (this.subjectString == null) {
            this.subjectString = new String(this.subjectBytes, 0, this.subjectBytes.length);
        }
        return this.subjectString;
    }

    public void setSubject(String subject) {
        if (subject == null || subject.trim().isEmpty()) {
            throw new IllegalArgumentException("Subject cannot be null, empty, or whitespace.");
        }
        this.subjectString = subject.trim();
        this.subjectBytes = this.subjectString.getBytes();
    }

    byte[] getSubjectBytes() {
        return this.subjectBytes;
    }

    void setSubject(byte[] subject, int length) {
        this.subjectBytes = Arrays.copyOf(subject, length);
    }

    public String getReplyTo() {
        if (this.replyToString == null && this.replyToBytes != null) {
            this.replyToString = new String(this.replyToBytes, 0, this.replyToBytes.length);
        }
        return this.replyToString;
    }

    public void setReplyTo(String replyTo) {
        if (replyTo == null) {
            this.replyToBytes = null;
            this.replyToString = null;
        } else {
            String reply = replyTo.trim();
            if (reply.isEmpty()) {
                throw new IllegalArgumentException("Reply subject cannot be empty or whitespace.");
            }
            this.replyToString = replyTo;
            this.replyToBytes = replyTo.getBytes();
        }
    }

    byte[] getReplyToBytes() {
        return this.replyToBytes;
    }

    void setReplyTo(byte[] replyTo, int length) {
        if (replyTo == null) {
            this.replyToBytes = null;
            this.replyToString = null;
        } else {
            this.replyToBytes = Arrays.copyOf(replyTo, length);
        }
    }

    public Subscription getSubscription() {
        return this.sub;
    }

    public void setData(byte[] data, int offset, int length) {
        if (data == null) {
            this.data = null;
        } else {
            if (length > data.length) {
                throw new IllegalArgumentException("nats: source buffer smaller than requested copy length");
            }
            this.data = new byte[length];
            System.arraycopy(data, offset, this.data, 0, length);
        }
    }

    public String toString() {
        int maxBytes = 32;
        int len = 0;
        byte[] buf = this.getData();
        if (buf != null) {
            len = buf.length;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("{Subject=%s;Reply=%s;Payload=<", this.getSubject(), this.getReplyTo()));
        for (int i = 0; i < 32 && i < len; ++i) {
            sb.append((char)buf[i]);
        }
        int remainder = len - 32;
        if (remainder > 0) {
            sb.append(String.format("%d more bytes", remainder));
        }
        sb.append(">}");
        return sb.toString();
    }
}

