/*
 * Decompiled with CFR 0.152.
 */
package io.nats.streaming;

import io.nats.streaming.protobuf.StartPosition;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class SubscriptionOptions {
    private final String durableName;
    private final int maxInFlight;
    private final Duration ackWait;
    StartPosition startAt;
    final long startSequence;
    private final Instant startTime;
    private final boolean manualAcks;

    private SubscriptionOptions(Builder builder) {
        this.durableName = builder.durableName;
        this.maxInFlight = builder.maxInFlight;
        this.ackWait = builder.ackWait;
        this.startAt = builder.startAt;
        this.startSequence = builder.startSequence;
        this.startTime = builder.startTime;
        this.manualAcks = builder.manualAcks;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public int getMaxInFlight() {
        return this.maxInFlight;
    }

    public Duration getAckWait() {
        return this.ackWait;
    }

    public StartPosition getStartAt() {
        return this.startAt;
    }

    public long getStartSequence() {
        return this.startSequence;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public long getStartTime(TimeUnit unit) {
        long totalNanos = TimeUnit.SECONDS.toNanos(this.startTime.getEpochSecond());
        return unit.convert(totalNanos += (long)this.startTime.getNano(), TimeUnit.NANOSECONDS);
    }

    public boolean isManualAcks() {
        return this.manualAcks;
    }

    public String toString() {
        return "SubscriptionOptions{durableName='" + this.durableName + '\'' + ", maxInFlight=" + this.maxInFlight + ", ackWait=" + this.ackWait + ", startAt=" + this.startAt + ", startSequence=" + this.startSequence + ", startTime=" + this.startTime + ", manualAcks=" + this.manualAcks + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionOptions that = (SubscriptionOptions)o;
        if (this.maxInFlight != that.maxInFlight) {
            return false;
        }
        if (this.startSequence != that.startSequence) {
            return false;
        }
        if (this.manualAcks != that.manualAcks) {
            return false;
        }
        if (this.durableName != null ? !this.durableName.equals(that.durableName) : that.durableName != null) {
            return false;
        }
        if (this.ackWait != null ? !this.ackWait.equals(that.ackWait) : that.ackWait != null) {
            return false;
        }
        if (this.startAt != that.startAt) {
            return false;
        }
        return this.startTime != null ? this.startTime.equals(that.startTime) : that.startTime == null;
    }

    public int hashCode() {
        int result = this.durableName != null ? this.durableName.hashCode() : 0;
        result = 31 * result + this.maxInFlight;
        result = 31 * result + (this.ackWait != null ? this.ackWait.hashCode() : 0);
        result = 31 * result + (this.startAt != null ? this.startAt.hashCode() : 0);
        result = 31 * result + (int)(this.startSequence ^ this.startSequence >>> 32);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.manualAcks ? 1 : 0);
        return result;
    }

    public static final class Builder
    implements Serializable {
        private static final long serialVersionUID = 1476017376308805473L;
        String durableName;
        int maxInFlight = 1024;
        Duration ackWait = Duration.ofMillis(30000L);
        StartPosition startAt = StartPosition.NewOnly;
        long startSequence;
        Instant startTime;
        boolean manualAcks;
        Date startTimeAsDate;

        public Builder setDurableName(String durableName) {
            return this.durableName(durableName);
        }

        public Builder durableName(String durableName) {
            this.durableName = durableName;
            return this;
        }

        public Builder setMaxInFlight(int max) {
            return this.maxInFlight(max);
        }

        public Builder maxInFlight(int max) {
            this.maxInFlight = max;
            return this;
        }

        public Builder setAckWait(Duration ackWait) {
            return this.ackWait(ackWait);
        }

        public Builder setAckWait(long ackWait, TimeUnit unit) {
            return this.ackWait(ackWait, unit);
        }

        public Builder ackWait(Duration ackWait) {
            this.ackWait = ackWait;
            return this;
        }

        public Builder ackWait(long ackWait, TimeUnit unit) {
            this.ackWait = Duration.ofMillis(unit.toMillis(ackWait));
            return this;
        }

        public Builder setManualAcks(boolean manualAcks) {
            return this.manualAcks();
        }

        public Builder manualAcks() {
            this.manualAcks = true;
            return this;
        }

        public Builder startAtSequence(long seq) {
            this.startAt = StartPosition.SequenceStart;
            this.startSequence = seq;
            return this;
        }

        public Builder startAtTime(Instant start) {
            this.startAt = StartPosition.TimeDeltaStart;
            this.startTime = start;
            return this;
        }

        public Builder startAtTimeDelta(long ago, TimeUnit unit) {
            this.startAt = StartPosition.TimeDeltaStart;
            this.startTime = Instant.now().minusNanos(unit.toNanos(ago));
            return this;
        }

        public Builder startAtTimeDelta(Duration ago) {
            this.startAt = StartPosition.TimeDeltaStart;
            this.startTime = Instant.now().minusNanos(ago.toNanos());
            return this;
        }

        public Builder startWithLastReceived() {
            this.startAt = StartPosition.LastReceived;
            return this;
        }

        public Builder deliverAllAvailable() {
            this.startAt = StartPosition.First;
            return this;
        }

        public SubscriptionOptions build() {
            return new SubscriptionOptions(this);
        }
    }
}

