/*
 * Decompiled with CFR 0.152.
 */
package io.nats.streaming;

import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.streaming.SubscriptionOptions;
import java.io.Serializable;
import java.time.Duration;

public class Options {
    private final String natsUrl;
    private final Connection natsConn;
    Duration connectTimeout;
    private final Duration ackTimeout;
    private final String discoverPrefix;
    private final int maxPubAcksInFlight;
    private ErrorListener errorListener;
    private ConnectionListener connectionListener;

    private Options(Builder builder) {
        this.natsUrl = builder.natsUrl;
        this.natsConn = builder.natsConn;
        this.connectTimeout = builder.connectTimeout;
        this.ackTimeout = builder.ackTimeout;
        this.discoverPrefix = builder.discoverPrefix;
        this.maxPubAcksInFlight = builder.maxPubAcksInFlight;
        this.connectionListener = builder.connectionListener;
        this.errorListener = builder.errorListener;
    }

    String getNatsUrl() {
        return this.natsUrl;
    }

    ErrorListener getErrorListener() {
        return this.errorListener;
    }

    ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    Connection getNatsConn() {
        return this.natsConn;
    }

    Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    Duration getAckTimeout() {
        return this.ackTimeout;
    }

    String getDiscoverPrefix() {
        return this.discoverPrefix;
    }

    int getMaxPubAcksInFlight() {
        return this.maxPubAcksInFlight;
    }

    public static final class Builder
    implements Serializable {
        private static final long serialVersionUID = 4774214916207501660L;
        private String natsUrl = "nats://localhost:4222";
        private transient Connection natsConn;
        private Duration connectTimeout = Duration.ofSeconds(5L);
        private Duration ackTimeout = SubscriptionOptions.DEFAULT_ACK_WAIT;
        private String discoverPrefix = "_STAN.discover";
        private int maxPubAcksInFlight = 16384;
        private ErrorListener errorListener;
        private ConnectionListener connectionListener;

        public Builder() {
        }

        public Builder(Options template) {
            this.natsUrl = template.natsUrl;
            this.natsConn = template.natsConn;
            this.connectTimeout = template.connectTimeout;
            this.ackTimeout = template.ackTimeout;
            this.discoverPrefix = template.discoverPrefix;
            this.maxPubAcksInFlight = template.maxPubAcksInFlight;
        }

        public Builder errorListener(ErrorListener listener) {
            this.errorListener = listener;
            return this;
        }

        public Builder connectionListener(ConnectionListener listener) {
            this.connectionListener = listener;
            return this;
        }

        public Builder pubAckWait(Duration ackTimeout) {
            this.ackTimeout = ackTimeout;
            return this;
        }

        public Builder connectWait(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder discoverPrefix(String discoverPrefix) {
            this.discoverPrefix = discoverPrefix;
            return this;
        }

        public Builder maxPubAcksInFlight(int maxPubAcksInFlight) {
            this.maxPubAcksInFlight = maxPubAcksInFlight;
            return this;
        }

        public Builder natsConn(Connection natsConn) {
            this.natsConn = natsConn;
            return this;
        }

        public Builder natsUrl(String natsUrl) {
            this.natsUrl = natsUrl;
            return this;
        }

        public Options build() {
            return new Options(this);
        }
    }
}

