/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.AttributeKeyImpl;
import io.opentelemetry.api.common.AttributeType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface AttributeKey<T>
extends Comparable<AttributeKey> {
    public String getKey();

    @Nonnull
    public AttributeType getType();

    public static AttributeKey<String> stringKey(String key) {
        return AttributeKeyImpl.create(key, AttributeType.STRING);
    }

    public static AttributeKey<Boolean> booleanKey(String key) {
        return AttributeKeyImpl.create(key, AttributeType.BOOLEAN);
    }

    public static AttributeKey<Long> longKey(String key) {
        return AttributeKeyImpl.create(key, AttributeType.LONG);
    }

    public static AttributeKey<Double> doubleKey(String key) {
        return AttributeKeyImpl.create(key, AttributeType.DOUBLE);
    }

    public static AttributeKey<List<String>> stringArrayKey(String key) {
        return AttributeKeyImpl.create(key, AttributeType.STRING_ARRAY);
    }

    public static AttributeKey<List<Boolean>> booleanArrayKey(String key) {
        return AttributeKeyImpl.create(key, AttributeType.BOOLEAN_ARRAY);
    }

    public static AttributeKey<List<Long>> longArrayKey(String key) {
        return AttributeKeyImpl.create(key, AttributeType.LONG_ARRAY);
    }

    public static AttributeKey<List<Double>> doubleArrayKey(String key) {
        return AttributeKeyImpl.create(key, AttributeType.DOUBLE_ARRAY);
    }
}

