/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.jdbc;

import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.jdbc.CfJdbcService;
import io.pivotal.cfenv.jdbc.JdbcUrlCreator;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class CfJdbcUrlCreator {
    private List<CfJdbcService> cfJdbcServices;

    public CfJdbcUrlCreator(List<CfService> cfServices) {
        ArrayList<JdbcUrlCreator> jdbcUrlCreators = new ArrayList<JdbcUrlCreator>();
        ServiceLoader<JdbcUrlCreator> jdbcUrlCreatorIterable = ServiceLoader.load(JdbcUrlCreator.class);
        for (JdbcUrlCreator jdbcUrlCreator : jdbcUrlCreatorIterable) {
            if (jdbcUrlCreator == null) continue;
            jdbcUrlCreators.add(jdbcUrlCreator);
        }
        this.cfJdbcServices = new ArrayList<CfJdbcService>();
        for (CfService cfService : cfServices) {
            for (JdbcUrlCreator jdbcUrlCreator : jdbcUrlCreators) {
                if (!jdbcUrlCreator.isDatabaseService(cfService)) continue;
                CfJdbcService cfJdbcService = new CfJdbcService(cfService.getMap());
                String jdbcUrl = jdbcUrlCreator.createJdbcUrl(cfService);
                cfJdbcService.getCredentials().getDerivedCredentials().put("driver-class-name", jdbcUrlCreator.getDriverClassName());
                cfJdbcService.getCredentials().getDerivedCredentials().put("jdbcUrl", jdbcUrl);
                this.cfJdbcServices.add(cfJdbcService);
            }
        }
    }

    public List<CfJdbcService> findJdbcServices() {
        return this.cfJdbcServices;
    }

    public CfJdbcService findJdbcServiceByName(String ... spec) {
        ArrayList<CfJdbcService> matchingJdbcServices = new ArrayList<CfJdbcService>();
        for (CfJdbcService cfJdbcService : this.cfJdbcServices) {
            if (spec == null) continue;
            for (String regex : spec) {
                String name = cfJdbcService.getName();
                if (name == null || name.length() <= 0 || !name.matches(regex)) continue;
                matchingJdbcServices.add(cfJdbcService);
            }
        }
        if (matchingJdbcServices.size() == 1) {
            return (CfJdbcService)((Object)matchingJdbcServices.stream().findFirst().get());
        }
        String specMessage = spec == null ? "null" : String.join((CharSequence)", ", spec);
        this.throwExceptionIfMultipleMatchesByName(matchingJdbcServices, specMessage, "name");
        throw new IllegalArgumentException("No database service with name [" + specMessage + "] was found.");
    }

    public CfJdbcService findJdbcService() {
        if (this.cfJdbcServices.size() == 1) {
            return (CfJdbcService)((Object)this.cfJdbcServices.stream().findFirst().get());
        }
        this.throwExceptionIfMultipleMatches(this.cfJdbcServices);
        return null;
    }

    private void throwExceptionIfMultipleMatches(List<CfJdbcService> services) {
        if (services.size() > 1) {
            CharSequence[] names = (String[])services.stream().map(CfService::getName).toArray(String[]::new);
            throw new IllegalArgumentException("No unique database service found. Found database service names [" + String.join((CharSequence)", ", names) + "]");
        }
    }

    private void throwExceptionIfMultipleMatchesByName(List<CfJdbcService> services, String specMessage, String operation) {
        if (services.size() > 1) {
            CharSequence[] names = (String[])services.stream().map(CfService::getName).toArray(String[]::new);
            throw new IllegalArgumentException("No unique database service matching by " + operation + " [" + specMessage + "] was found.  Matching service names are [" + String.join((CharSequence)", ", names) + "]");
        }
    }
}

