/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.CKMSQuantiles;
import io.prometheus.client.Collector;
import io.prometheus.client.DoubleAdder;
import io.prometheus.client.SimpleCollector;
import io.prometheus.client.SimpleTimer;
import io.prometheus.client.SummaryMetricFamily;
import io.prometheus.client.TimeWindowQuantiles;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class Summary
extends SimpleCollector<Child>
implements Collector.Describable {
    final List<CKMSQuantiles.Quantile> quantiles;
    final long maxAgeSeconds;
    final int ageBuckets;

    Summary(Builder b) {
        super(b);
        this.quantiles = Collections.unmodifiableList(new ArrayList(b.quantiles));
        this.maxAgeSeconds = b.maxAgeSeconds;
        this.ageBuckets = b.ageBuckets;
        this.initializeNoLabelsChild();
    }

    public static Builder build(String name, String help) {
        return (Builder)((Builder)new Builder().name(name)).help(help);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child(this.quantiles, this.maxAgeSeconds, this.ageBuckets);
    }

    public void observe(double amt) {
        ((Child)this.noLabelsChild).observe(amt);
    }

    public Timer startTimer() {
        return ((Child)this.noLabelsChild).startTimer();
    }

    public double time(Runnable timeable) {
        return ((Child)this.noLabelsChild).time(timeable);
    }

    public <E> E time(Callable<E> timeable) {
        return ((Child)this.noLabelsChild).time(timeable);
    }

    public Child.Value get() {
        return ((Child)this.noLabelsChild).get();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            Child.Value v = ((Child)c.getValue()).get();
            ArrayList<String> labelNamesWithQuantile = new ArrayList<String>(this.labelNames);
            labelNamesWithQuantile.add("quantile");
            for (Map.Entry<Double, Double> q : v.quantiles.entrySet()) {
                ArrayList<String> labelValuesWithQuantile = new ArrayList<String>((Collection)c.getKey());
                labelValuesWithQuantile.add(Summary.doubleToGoString(q.getKey()));
                samples.add(new Collector.MetricFamilySamples.Sample(this.fullname, labelNamesWithQuantile, labelValuesWithQuantile, q.getValue()));
            }
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_count", this.labelNames, (List)c.getKey(), v.count));
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_sum", this.labelNames, (List)c.getKey(), v.sum));
        }
        return this.familySamplesList(Collector.Type.SUMMARY, samples);
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        return Collections.singletonList(new SummaryMetricFamily(this.fullname, this.help, this.labelNames));
    }

    public static class Child {
        private final DoubleAdder count = new DoubleAdder();
        private final DoubleAdder sum = new DoubleAdder();
        private final List<CKMSQuantiles.Quantile> quantiles;
        private final TimeWindowQuantiles quantileValues;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double time(Runnable timeable) {
            double elapsed;
            Timer timer = this.startTimer();
            try {
                timeable.run();
            }
            finally {
                elapsed = timer.observeDuration();
            }
            return elapsed;
        }

        public <E> E time(Callable<E> timeable) {
            Timer timer = this.startTimer();
            try {
                E e = timeable.call();
                return e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                timer.observeDuration();
            }
        }

        private Child(List<CKMSQuantiles.Quantile> quantiles, long maxAgeSeconds, int ageBuckets) {
            this.quantiles = quantiles;
            this.quantileValues = quantiles.size() > 0 ? new TimeWindowQuantiles(quantiles.toArray(new CKMSQuantiles.Quantile[0]), maxAgeSeconds, ageBuckets) : null;
        }

        public void observe(double amt) {
            this.count.add(1.0);
            this.sum.add(amt);
            if (this.quantileValues != null) {
                this.quantileValues.insert(amt);
            }
        }

        public Timer startTimer() {
            return new Timer(this, SimpleTimer.defaultTimeProvider.nanoTime());
        }

        public Value get() {
            return new Value(this.count.sum(), this.sum.sum(), this.quantiles, this.quantileValues);
        }

        public static class Value {
            public final double count;
            public final double sum;
            public final SortedMap<Double, Double> quantiles;

            private Value(double count, double sum, List<CKMSQuantiles.Quantile> quantiles, TimeWindowQuantiles quantileValues) {
                this.count = count;
                this.sum = sum;
                this.quantiles = Collections.unmodifiableSortedMap(this.snapshot(quantiles, quantileValues));
            }

            private SortedMap<Double, Double> snapshot(List<CKMSQuantiles.Quantile> quantiles, TimeWindowQuantiles quantileValues) {
                TreeMap<Double, Double> result = new TreeMap<Double, Double>();
                for (CKMSQuantiles.Quantile q : quantiles) {
                    result.put(q.quantile, quantileValues.get(q.quantile));
                }
                return result;
            }
        }
    }

    public static class Timer
    implements Closeable {
        private final Child child;
        private final long start;

        private Timer(Child child, long start) {
            this.child = child;
            this.start = start;
        }

        public double observeDuration() {
            double elapsed = SimpleTimer.elapsedSecondsFromNanos(this.start, SimpleTimer.defaultTimeProvider.nanoTime());
            this.child.observe(elapsed);
            return elapsed;
        }

        @Override
        public void close() {
            this.observeDuration();
        }
    }

    public static class Builder
    extends SimpleCollector.Builder<Builder, Summary> {
        private final List<CKMSQuantiles.Quantile> quantiles = new ArrayList<CKMSQuantiles.Quantile>();
        private long maxAgeSeconds = TimeUnit.MINUTES.toSeconds(10L);
        private int ageBuckets = 5;

        public Builder quantile(double quantile, double error) {
            if (quantile < 0.0 || quantile > 1.0) {
                throw new IllegalArgumentException("Quantile " + quantile + " invalid: Expected number between 0.0 and 1.0.");
            }
            if (error < 0.0 || error > 1.0) {
                throw new IllegalArgumentException("Error " + error + " invalid: Expected number between 0.0 and 1.0.");
            }
            this.quantiles.add(new CKMSQuantiles.Quantile(quantile, error));
            return this;
        }

        public Builder maxAgeSeconds(long maxAgeSeconds) {
            if (maxAgeSeconds <= 0L) {
                throw new IllegalArgumentException("maxAgeSeconds cannot be " + maxAgeSeconds);
            }
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public Builder ageBuckets(int ageBuckets) {
            if (ageBuckets <= 0) {
                throw new IllegalArgumentException("ageBuckets cannot be " + ageBuckets);
            }
            this.ageBuckets = ageBuckets;
            return this;
        }

        @Override
        public Summary create() {
            for (String label : this.labelNames) {
                if (!label.equals("quantile")) continue;
                throw new IllegalStateException("Summary cannot have a label named 'quantile'.");
            }
            this.dontInitializeNoLabelsChild = true;
            return new Summary(this);
        }
    }
}

