/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import ratpack.func.Action;
import ratpack.sse.Event;
import ratpack.sse.internal.DefaultEvent;

public class ServerSentEventDecoder {
    private static final char LINE_FEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char[] EVENT_ID_FIELD_NAME = "event".toCharArray();
    private static final char[] DATA_FIELD_NAME = "data".toCharArray();
    private static final char[] ID_FIELD_NAME = "id".toCharArray();
    private static final ByteProcessor SCAN_EOL_PROCESSOR = value -> !ServerSentEventDecoder.isLineDelimiter((char)value);
    private static final ByteProcessor SCAN_COLON_PROCESSOR = value -> (char)value != ':';
    private static final ByteProcessor SKIP_COLON_AND_WHITE_SPACE_PROCESSOR = value -> {
        char valueChar = (char)value;
        return valueChar == ':' || valueChar == ' ';
    };
    public static final ServerSentEventDecoder INSTANCE = new ServerSentEventDecoder();

    private ServerSentEventDecoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ByteBuf in, ByteBufAllocator bufferAllocator, Action<Event<?>> eventAction) throws Exception {
        ByteBuf currentLineBuffer = null;
        String eventData = null;
        String eventType = null;
        String eventId = null;
        Enum currentFieldType = null;
        State state = State.ReadLine;
        try {
            block19: while (in.isReadable()) {
                int readerIndexAtStart = in.readerIndex();
                switch (state) {
                    case ReadLine: {
                        int endOfLineStartIndex = ServerSentEventDecoder.scanAndFindEndOfLine(in);
                        if (-1 == endOfLineStartIndex) {
                            in.readerIndex(in.capacity());
                            break;
                        }
                        int bytesAvailableInThisLine = endOfLineStartIndex - readerIndexAtStart;
                        if (bytesAvailableInThisLine == 0) {
                            state = State.DispatchEvent;
                            break;
                        }
                        currentLineBuffer = bufferAllocator.buffer(bytesAvailableInThisLine, bytesAvailableInThisLine);
                        in.readBytes(currentLineBuffer, bytesAvailableInThisLine);
                        state = State.ReadFieldName;
                        break;
                    }
                    case DispatchEvent: {
                        eventAction.execute(new DefaultEvent().id(eventId).event(eventType).data(eventData));
                        eventId = null;
                        eventType = null;
                        eventData = null;
                        state = State.SkipTillEOL;
                        break;
                    }
                    case ReadFieldName: {
                        int indexOfColon = ServerSentEventDecoder.scanAndFindColon(currentLineBuffer);
                        if (-1 == indexOfColon) {
                            indexOfColon = currentLineBuffer.capacity();
                        }
                        if (1 == indexOfColon) {
                            state = State.ReadLine;
                            currentLineBuffer.release();
                            break;
                        }
                        ByteBuf fieldNameBuffer = bufferAllocator.buffer(indexOfColon, indexOfColon);
                        currentLineBuffer.readBytes(fieldNameBuffer, indexOfColon);
                        state = State.SkipColonAndWhiteSpaces;
                        try {
                            currentFieldType = ServerSentEventDecoder.readCurrentFieldTypeFromBuffer(fieldNameBuffer);
                            continue block19;
                        }
                        finally {
                            if (null == currentFieldType) {
                                state = State.SkipTillEOL;
                            }
                            fieldNameBuffer.release();
                            continue block19;
                        }
                    }
                    case SkipColonAndWhiteSpaces: {
                        ServerSentEventDecoder.skipColonAndWhiteSpaces(currentLineBuffer);
                        state = State.ReadFieldValue;
                        break;
                    }
                    case SkipTillEOL: {
                        ServerSentEventDecoder.skipTilEOL(in);
                        state = State.ReadLine;
                        break;
                    }
                    case ReadFieldValue: {
                        int bytesAvailableInThisValue = currentLineBuffer.readableBytes();
                        ByteBuf currentFieldValue = bufferAllocator.buffer(bytesAvailableInThisValue, bytesAvailableInThisValue);
                        currentLineBuffer.readBytes(currentFieldValue, bytesAvailableInThisValue);
                        state = State.SkipTillEOL;
                        switch (1.$SwitchMap$ratpack$sse$internal$ServerSentEventDecoder$FieldName[currentFieldType.ordinal()]) {
                            case 1: {
                                if (null == eventData) {
                                    eventData = currentFieldValue.toString(CharsetUtil.UTF_8);
                                    break;
                                }
                                eventData = eventData + '\n' + currentFieldValue.toString(CharsetUtil.UTF_8);
                                break;
                            }
                            case 2: {
                                eventId = currentFieldValue.toString(CharsetUtil.UTF_8);
                                break;
                            }
                            case 3: {
                                eventType = currentFieldValue.toString(CharsetUtil.UTF_8);
                            }
                        }
                        currentFieldValue.release();
                        currentLineBuffer.release();
                    }
                }
            }
        }
        finally {
            in.release();
        }
    }

    private static int scanAndFindColon(ByteBuf byteBuf) {
        return byteBuf.forEachByte(SCAN_COLON_PROCESSOR);
    }

    private static int scanAndFindEndOfLine(ByteBuf byteBuf) {
        return byteBuf.forEachByte(SCAN_EOL_PROCESSOR);
    }

    private static boolean skipColonAndWhiteSpaces(ByteBuf byteBuf) {
        return ServerSentEventDecoder.skipTillMatching(byteBuf, SKIP_COLON_AND_WHITE_SPACE_PROCESSOR);
    }

    private static boolean skipTilEOL(ByteBuf byteBuf) {
        if (ServerSentEventDecoder.skipLineFeed(byteBuf)) {
            return ServerSentEventDecoder.skipCarriageReturn(byteBuf);
        }
        return ServerSentEventDecoder.skipCarriageReturn(byteBuf) && ServerSentEventDecoder.skipLineFeed(byteBuf);
    }

    private static boolean skipLineFeed(ByteBuf byteBuf) {
        return ServerSentEventDecoder.skipTillFirstMatching(byteBuf, (byte)10);
    }

    private static boolean skipCarriageReturn(ByteBuf byteBuf) {
        return ServerSentEventDecoder.skipTillFirstMatching(byteBuf, (byte)13);
    }

    private static boolean skipTillMatching(ByteBuf byteBuf, ByteProcessor processor) {
        int lastIndexProcessed = byteBuf.forEachByte(processor);
        if (-1 == lastIndexProcessed) {
            byteBuf.readerIndex(byteBuf.readerIndex() + byteBuf.readableBytes());
        } else {
            byteBuf.readerIndex(lastIndexProcessed);
        }
        return -1 != lastIndexProcessed;
    }

    private static boolean skipTillFirstMatching(ByteBuf byteBuf, byte thing) {
        int i = byteBuf.indexOf(byteBuf.readerIndex(), byteBuf.capacity(), thing);
        if (-1 == i) {
            return false;
        }
        byteBuf.readByte();
        return true;
    }

    private static FieldName readCurrentFieldTypeFromBuffer(ByteBuf fieldNameBuffer) {
        FieldName toReturn = FieldName.Data;
        int readableBytes = fieldNameBuffer.readableBytes();
        int readerIndexAtStart = fieldNameBuffer.readerIndex();
        char[] fieldNameToVerify = DATA_FIELD_NAME;
        boolean verified = false;
        int actualFieldNameIndexToCheck = 0;
        block5: for (int i = readerIndexAtStart; i < readableBytes; ++i) {
            char charAtI = (char)fieldNameBuffer.getByte(i);
            if (i == readerIndexAtStart) {
                switch (charAtI) {
                    case 'e': {
                        fieldNameToVerify = EVENT_ID_FIELD_NAME;
                        toReturn = FieldName.Event;
                        continue block5;
                    }
                    case 'd': {
                        fieldNameToVerify = DATA_FIELD_NAME;
                        toReturn = FieldName.Data;
                        continue block5;
                    }
                    case 'i': {
                        fieldNameToVerify = ID_FIELD_NAME;
                        toReturn = FieldName.Id;
                        continue block5;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (++actualFieldNameIndexToCheck >= fieldNameToVerify.length || charAtI != fieldNameToVerify[actualFieldNameIndexToCheck]) {
                verified = false;
                break;
            }
            verified = true;
        }
        if (verified) {
            return toReturn;
        }
        return null;
    }

    private static boolean isLineDelimiter(char c) {
        return c == '\r' || c == '\n';
    }

    private static enum FieldName {
        Event,
        Data,
        Id;

    }

    private static enum State {
        SkipColonAndWhiteSpaces,
        SkipTillEOL,
        ReadFieldName,
        ReadFieldValue,
        ReadLine,
        DispatchEvent;

    }
}

