/*
 * Decompiled with CFR 0.152.
 */
package ratpack.func;

import java.util.function.Consumer;
import ratpack.api.Nullable;
import ratpack.func.Block;
import ratpack.util.Exceptions;

@FunctionalInterface
public interface Action<T> {
    public void execute(T var1) throws Exception;

    public static Action<Object> noop() {
        return thing -> {};
    }

    public static <T> Action<? super T> noopIfNull(@Nullable Action<T> action) {
        if (action == null) {
            return Action.noop();
        }
        return action;
    }

    @SafeVarargs
    public static <T> Action<T> join(Action<? super T> ... actions) {
        return thing -> {
            for (Action action : actions) {
                action.execute(thing);
            }
        };
    }

    default public <O extends T> Action<O> append(Action<? super O> action) {
        Action self = this;
        return thing -> {
            self.execute(thing);
            action.execute((Object)thing);
        };
    }

    default public <O extends T> Action<O> prepend(Action<? super O> action) {
        return action.append(this);
    }

    public static Action<Throwable> throwException() {
        return throwable -> {
            throw Exceptions.toException(throwable);
        };
    }

    public static <T> Action<T> throwException(Throwable throwable) {
        return t -> {
            throw Exceptions.toException(throwable);
        };
    }

    public static <T> Action<T> ignoreArg(Block block) {
        return t -> block.execute();
    }

    public static <T> T with(T t, Action<? super T> action) throws Exception {
        return action.with(t);
    }

    default public <O extends T> O with(O o) throws Exception {
        this.execute(o);
        return o;
    }

    public static <T> T uncheckedWith(T t, Action<? super T> action) {
        return action.uncheckedWith(t);
    }

    default public <O extends T> O uncheckedWith(O o) {
        return (O)Exceptions.uncheck(() -> {
            this.execute(o);
            return o;
        });
    }

    default public Consumer<T> toConsumer() {
        return t -> {
            try {
                this.execute(t);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T> Action<T> from(Consumer<T> consumer) {
        return consumer::accept;
    }

    default public Block curry(T value) {
        return () -> this.execute(value);
    }
}

