/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http;

import io.netty.handler.codec.http.HttpResponseStatus;
import ratpack.http.internal.DefaultStatus;

public interface Status {
    public static final Status OK = Status.of(200);
    public static final Status NOT_MODIFIED = Status.of(304);

    public static Status of(int code, String message) {
        return new DefaultStatus(new HttpResponseStatus(code, message));
    }

    public static Status of(int code) {
        return new DefaultStatus(HttpResponseStatus.valueOf((int)code));
    }

    public int getCode();

    public String getMessage();

    default public boolean is1xx() {
        return this.getCode() >= 100 && this.getCode() < 200;
    }

    default public boolean is2xx() {
        return this.getCode() >= 200 && this.getCode() < 300;
    }

    default public boolean is3xx() {
        return this.getCode() >= 300 && this.getCode() < 400;
    }

    default public boolean is4xx() {
        return this.getCode() >= 400 && this.getCode() < 500;
    }

    default public boolean is5xx() {
        return this.getCode() >= 500 && this.getCode() < 600;
    }

    public HttpResponseStatus getNettyStatus();
}

