/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client;

import io.netty.buffer.ByteBufAllocator;
import java.net.URI;
import java.time.Duration;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.http.client.HttpClientSpec;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.StreamedResponse;
import ratpack.http.client.internal.DefaultHttpClient;
import ratpack.registry.Registry;
import ratpack.server.ServerConfig;
import ratpack.util.Exceptions;

public interface HttpClient
extends AutoCloseable {
    public static HttpClient of(Action<? super HttpClientSpec> action) throws Exception {
        return DefaultHttpClient.of(action);
    }

    public Promise<ReceivedResponse> get(URI var1, Action<? super RequestSpec> var2);

    default public Promise<ReceivedResponse> get(URI uri) {
        return this.get(uri, Action.noop());
    }

    public ByteBufAllocator getByteBufAllocator();

    public int getPoolSize();

    public Duration getReadTimeout();

    public int getMaxContentLength();

    @Override
    public void close();

    public Promise<ReceivedResponse> post(URI var1, Action<? super RequestSpec> var2);

    public Promise<ReceivedResponse> request(URI var1, Action<? super RequestSpec> var2);

    public Promise<StreamedResponse> requestStream(URI var1, Action<? super RequestSpec> var2);

    @Deprecated
    public static HttpClient httpClient(ServerConfig serverConfig, Registry registry) {
        return Exceptions.uncheck(() -> HttpClient.of(s -> s.poolSize(0).byteBufAllocator(registry.get(ByteBufAllocator.class)).maxContentLength(serverConfig.getMaxContentLength())));
    }

    @Deprecated
    public static HttpClient httpClient(ByteBufAllocator byteBufAllocator, int maxContentLengthBytes) {
        return Exceptions.uncheck(() -> HttpClient.of(s -> s.poolSize(0).byteBufAllocator(byteBufAllocator).maxContentLength(maxContentLengthBytes)));
    }
}

