/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.bytebuf.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.stream.TransformablePublisher;
import ratpack.stream.internal.ManagedSubscription;

public class ByteBufComposingPublisher
implements TransformablePublisher<CompositeByteBuf> {
    private final Publisher<? extends ByteBuf> upstream;
    private final ByteBufAllocator alloc;
    private final int maxNum;
    private final long watermark;

    public ByteBufComposingPublisher(int maxNum, long sizeWatermark, ByteBufAllocator alloc, Publisher<? extends ByteBuf> upstream) {
        this.upstream = upstream;
        this.alloc = alloc;
        this.maxNum = maxNum;
        this.watermark = sizeWatermark;
    }

    public void subscribe(Subscriber<? super CompositeByteBuf> subscriber) {
        subscriber.onSubscribe((Subscription)new ManagedSubscription<CompositeByteBuf>(subscriber, ReferenceCounted::release){
            private Subscription subscription;
            private CompositeByteBuf composite;
            private volatile State state;

            @Override
            protected void onRequest(long n) {
                if (this.subscription == null) {
                    ByteBufComposingPublisher.this.upstream.subscribe((Subscriber)new Subscriber<ByteBuf>(){

                        public void onSubscribe(Subscription s) {
                            subscription = s;
                            state = State.Fetching;
                            s.request(1L);
                        }

                        public void onNext(ByteBuf t) {
                            if (state == State.Closed) {
                                t.release();
                                return;
                            }
                            if (composite == null) {
                                composite = ByteBufComposingPublisher.this.alloc.compositeBuffer(ByteBufComposingPublisher.this.maxNum);
                            }
                            composite.addComponent(true, t);
                            if (composite.numComponents() == ByteBufComposingPublisher.this.maxNum || (long)composite.readableBytes() >= ByteBufComposingPublisher.this.watermark) {
                                state = State.Writing;
                                this.emitNext(composite);
                                composite = null;
                                this.maybeFetch();
                            } else {
                                subscription.request(1L);
                            }
                        }

                        public void onError(Throwable t) {
                            state = State.Closed;
                            ReferenceCountUtil.release((Object)composite);
                            this.emitError(t);
                        }

                        public void onComplete() {
                            state = State.Closed;
                            if (composite != null) {
                                this.emitNext(composite);
                            }
                            this.emitComplete();
                        }
                    });
                } else {
                    this.maybeFetch();
                }
            }

            private void maybeFetch() {
                if (this.getDemand() > 0L && this.state != State.Fetching) {
                    this.state = State.Fetching;
                    this.subscription.request(1L);
                }
            }

            @Override
            protected void onCancel() {
                this.state = State.Closed;
                ReferenceCountUtil.release((Object)this.composite);
                if (this.subscription != null) {
                    this.subscription.cancel();
                }
            }
        });
    }

    private static enum State {
        Fetching,
        Writing,
        Closed;

    }
}

