/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.util.retry;

import java.time.Duration;
import ratpack.exec.Promise;
import ratpack.exec.util.retry.AttemptRetryPolicyBuilder;
import ratpack.exec.util.retry.Delay;
import ratpack.exec.util.retry.RetryPolicy;
import ratpack.exec.util.retry.internal.DefaultAttemptRetryPolicyBuilder;
import ratpack.func.Action;

public final class AttemptRetryPolicy
implements RetryPolicy {
    private final Delay delay;
    private final int maxAttempts;
    private int attempts = 1;

    public AttemptRetryPolicy(Delay delay, int maxAttempts) {
        this.delay = delay;
        this.maxAttempts = maxAttempts;
    }

    public static AttemptRetryPolicy of(Action<? super AttemptRetryPolicyBuilder> definition) throws Exception {
        return definition.with(new DefaultAttemptRetryPolicyBuilder()).build();
    }

    @Override
    public boolean isExhausted() {
        return this.attempts > this.maxAttempts;
    }

    @Override
    public int attempts() {
        return this.attempts;
    }

    @Override
    public Promise<Duration> delay() {
        return this.delay.delay(this.attempts);
    }

    @Override
    public RetryPolicy increaseAttempt() {
        ++this.attempts;
        return this;
    }
}

