/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.util.retry;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import ratpack.exec.Promise;
import ratpack.exec.util.retry.Delay;
import ratpack.exec.util.retry.DurationRetryPolicyBuilder;
import ratpack.exec.util.retry.RetryPolicy;
import ratpack.exec.util.retry.internal.DefaultDurationRetryPolicyBuilder;
import ratpack.func.Action;

public class DurationRetryPolicy
implements RetryPolicy {
    private final Delay delay;
    private final Duration maxDuration;
    private Instant start;
    private int attempts = 1;
    private Clock clock;

    public DurationRetryPolicy(Delay delay, Duration maxDuration, Clock clock) {
        this.delay = delay;
        this.maxDuration = maxDuration;
        this.clock = clock;
    }

    public static DurationRetryPolicy of(Action<? super DurationRetryPolicyBuilder> definition) throws Exception {
        return definition.with(new DefaultDurationRetryPolicyBuilder()).build();
    }

    @Override
    public boolean isExhausted() {
        if (this.start == null) {
            this.start = this.clock.instant();
        }
        Instant limit = this.start.plusMillis(this.maxDuration.toMillis());
        Instant now = this.clock.instant();
        return now.isAfter(limit);
    }

    @Override
    public int attempts() {
        return this.attempts;
    }

    @Override
    public Promise<Duration> delay() {
        return this.delay.delay(this.attempts);
    }

    @Override
    public RetryPolicy increaseAttempt() {
        ++this.attempts;
        return this;
    }
}

