/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.reflect.TypeToken;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import ratpack.registry.internal.RegistryEntry;

public class LazyRegistryEntry<T>
implements RegistryEntry<T> {
    private final TypeToken<T> type;
    private final Supplier<? extends T> supplier;
    private final Lock lock = new ReentrantLock();
    private T object;

    public LazyRegistryEntry(TypeToken<T> type, Supplier<? extends T> supplier) {
        this.type = type;
        this.supplier = supplier;
    }

    @Override
    public TypeToken<T> getType() {
        return this.type;
    }

    @Override
    public T get() {
        if (this.object == null) {
            this.lock.lock();
            try {
                if (this.object == null) {
                    this.object = this.supplier.get();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.object;
    }

    public String toString() {
        return "LazyRegistryEntry{type=" + this.type + ", supplier=" + this.supplier + ", value=" + this.object + '}';
    }
}

