/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import io.netty.channel.EventLoop;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import ratpack.exec.Downstream;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.exec.Result;
import ratpack.exec.internal.Continuation;
import ratpack.exec.internal.DefaultExecution;
import ratpack.exec.internal.DefaultPromise;
import ratpack.exec.internal.ExecThreadBinding;
import ratpack.func.Block;
import ratpack.func.Factory;

public abstract class Blocking {
    private Blocking() {
    }

    public static <T> Promise<T> get(final Factory<T> factory) {
        return new DefaultPromise(downstream -> {
            final DefaultExecution execution = DefaultExecution.require();
            EventLoop eventLoop = execution.getEventLoop();
            execution.delimit(downstream::error, continuation -> eventLoop.execute(() -> CompletableFuture.supplyAsync(new Supplier<Result<T>>(){
                Result result;

                @Override
                public Result<T> get() {
                    try {
                        execution.bindToThread();
                        DefaultExecution.intercept(execution, ExecInterceptor.ExecType.BLOCKING, execution.getAllInterceptors().iterator(), () -> {
                            try {
                                this.result = Result.success(factory.create());
                            }
                            catch (Throwable e) {
                                this.result = Result.error(e);
                            }
                        });
                        Result result = this.result;
                        return result;
                    }
                    catch (Throwable e) {
                        DefaultExecution.interceptorError(e);
                        Result result = this.result;
                        return result;
                    }
                    finally {
                        execution.unbindFromThread();
                    }
                }
            }, execution.getController().getBlockingExecutor()).thenAcceptAsync(v -> continuation.resume(() -> downstream.accept(v)), (Executor)eventLoop)));
        });
    }

    public static <T> T on(Promise<T> promise) throws Exception {
        ExecThreadBinding.requireBlockingThread("Blocking.on() can only be used while blocking (i.e. use Blocking.get() first)");
        DefaultExecution execution = DefaultExecution.require();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference resultReference = new AtomicReference();
        execution.delimit(t -> {
            resultReference.set(Result.error(t));
            latch.countDown();
        }, continuation -> promise.connect(new Downstream<T>((Continuation)continuation, execution, resultReference, latch){
            final /* synthetic */ Continuation val$continuation;
            final /* synthetic */ DefaultExecution val$execution;
            final /* synthetic */ AtomicReference val$resultReference;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$continuation = continuation;
                this.val$execution = defaultExecution;
                this.val$resultReference = atomicReference;
                this.val$latch = countDownLatch;
            }

            @Override
            public void success(T value) {
                this.unlatch(Result.success(value));
            }

            @Override
            public void error(Throwable throwable) {
                this.unlatch(Result.error(throwable));
            }

            @Override
            public void complete() {
                this.unlatch(Result.success(null));
            }

            private void unlatch(Result<T> result) {
                this.val$continuation.resume(() -> this.val$execution.getEventLoop().execute(() -> {
                    this.val$resultReference.set(result);
                    this.val$latch.countDown();
                }));
            }
        }));
        execution.eventLoopDrain();
        latch.await();
        return ((Result)resultReference.get()).getValueOrThrow();
    }

    public static Operation op(Block block) {
        return Blocking.get(() -> {
            block.execute();
            return null;
        }).operation();
    }

    public static void exec(Block block) {
        Blocking.op(block).then();
    }
}

